package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.repository.MinimalRef;

import javax.annotation.Nonnull;

/**
 * Describes a {@link #getCommit() commit} that was removed / is about to be removed from a {@link #getRef() ref}.
 *
 * @see RepositoryHookCommitCallback
 * @since 5.0
 */
public interface CommitRemovedDetails {

    /**
     * @return the commit
     */
    @Nonnull
    Commit getCommit();

    /**
     * @return the ref the commit has been removed from / is about to be removed from
     */
    @Nonnull
    MinimalRef getRef();

    /**
     * @return {@code true} if the commit has been / is going to be removed from the repository. {@code false} if
     *         the commit is still referenced by another ref.
     *
     * @see RepositoryHookCommitFilter#REMOVED_FROM_REPOSITORY
     */
    boolean isRemovedFromRepository();
}
