package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.repository.MinimalRef;

import javax.annotation.Nonnull;

/**
 * Describes a {@link #getCommit() commit} that was added / is about to be added to a {@link #getRef() ref}.
 *
 * @see RepositoryHookCommitCallback
 * @since 5.0
 */
public interface CommitAddedDetails {

    /**
     * @return the commit
     */
    @Nonnull
    Commit getCommit();

    /**
     * @return the ref the commit has been added to / is about to be added to
     */
    @Nonnull
    MinimalRef getRef();

    /**
     * @return {@code true} if the commit is (going to be) introduced to the repository. {@code false} if the commit is
     *         already referenced by another ref.
     *
     * @see RepositoryHookCommitFilter#ADDED_TO_REPOSITORY
     */
    boolean isAddedToRepository();
}
