package com.atlassian.bitbucket.hook;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.bitbucket.util.Weighted;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;

import javax.annotation.Nonnull;

/**
 * Base implementation for scm hook module descriptor.
 *
 * @param <T> the module type
 */
public abstract class BaseScmHookModuleDescriptor<T> extends BaseWeightedModuleDescriptor<T> {

    private static final int DEFAULT_WEIGHT = 1000;

    private static final Function<ModuleDescriptor, String> TO_MODULE_KEY =
            descriptor -> null == descriptor ? "" : descriptor.getCompleteKey();

    protected T module;

    public BaseScmHookModuleDescriptor(@Nonnull ModuleFactory moduleFactory) {
        super(moduleFactory, DEFAULT_WEIGHT);
    }

    @Override
    public int compareTo(@Nonnull BaseWeightedModuleDescriptor<T> otherDescriptor) {
        //noinspection unchecked
        return Ordering.from(Weighted.COMPARABLE)
                .compound(Ordering.from(String.CASE_INSENSITIVE_ORDER).nullsLast().onResultOf(TO_MODULE_KEY))
                .compare(this, otherDescriptor);
    }

    @Override
    public T getModule() {
        return module;
    }

    @Override
    public void enabled() {
        super.enabled();
        module = moduleFactory.createModule(moduleClassName, this);
    }

    @Override
    public void disabled() {
        module = null;
        super.disabled();
    }
}
