package com.atlassian.bitbucket.home;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;

public class HomeUpdateHandlerModuleDescriptor extends BaseWeightedModuleDescriptor<HomeUpdateHandler> {

    public static final String XML_ELEMENT_NAME = "home-update-handler";

    public HomeUpdateHandlerModuleDescriptor(ModuleFactory moduleFactory) {
        this(moduleFactory, 100);
    }

    public HomeUpdateHandlerModuleDescriptor(ModuleFactory moduleFactory, int defaultWeight) {
        super(moduleFactory, defaultWeight);
    }

    /**
     * Retrieves the {@link HomeUpdateHandler} for this descriptor.
     * <p>
     * <i>No caching is done</i> on the handler instance. This is intentional, to allow plugins to implement their
     * handlers either as persistent services (using {@code bean:someName} notation) or as transient helpers.
     *
     * @return the handler for this descriptor
     */
    @Override
    public HomeUpdateHandler getModule() {
        return moduleFactory.createModule(moduleClassName, this);
    }
}
