package com.atlassian.bitbucket.home;

import javax.annotation.Nonnull;

/**
 * Describes the {@link #getOldDir() old} and {@link #getNewDir() new} <i>absolute paths</i> for the home directory.
 * <p>
 * Note: It is possible that the <i>operating system</i> has been changed between the two paths. This means, for
 * example, that the {@link #getOldDir() old} path could be a Windows path, like {@code C:\Stash\Home} while the
 * {@link #getNewDir() new} path is a Unix path, like {@code /var/data/stash/home}.
 */
public interface HomeUpdate {

    /**
     * The <i>absolute path</i> to where the home directory <i>currently is</i>.
     *
     * @return the current home directory
     */
    @Nonnull
    String getNewDir();

    /**
     * The <i>absolute path</i> to where the home directory <i>used to be</i>.
     *
     * @return the previous home directory
     */
    @Nonnull
    String getOldDir();
}
