package com.atlassian.bitbucket.home;

import javax.annotation.Nonnull;

/**
 * Provides a base class for implementing {@link HomeUpdateHandler}s.
 * <p>
 * Even if the implementation is going to provide a {@link #rollback(HomeUpdate) rollback} implementation, it is still
 * encouraged to extend from this base class. Doing so makes implementations more resilient to changes in the interface
 * for {@link HomeUpdateHandler}, increasing their compatibility with different versions of the system.
 */
public abstract class AbstractHomeUpdateHandler implements HomeUpdateHandler {

    /**
     * Provides a default no-op implementation to facilitate building handlers with no explicit rollback mechanism.
     *
     * @param update ignored
     */
    @Override
    public void rollback(@Nonnull HomeUpdate update) {
    }
}
