package com.atlassian.bitbucket.comment;

import javax.annotation.Nonnull;

/**
 * Provides properties to Stash {@link Comment comments}.
 * <p>
 * NOTE: Property values must be convertible to JSON (e.g. extend from {@code RestMapEntity}), or otherwise REST
 * requests to entities owning the properties will fail.
 *
 * @see CommentPropertyContext
 */
public interface CommentPropertyProvider {

    /**
     * Provide properties to the given {@code context}.
     *
     * @param context current comment context
     */
    void provideProperties(@Nonnull CommentPropertyContext context);
}
