package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.property.PropertyMap;

import javax.annotation.Nonnull;

/**
 * Allows iterating and adding {@link PropertyMap properties} on comments. This context
 * is guaranteed to not contain duplicate comments.
 * <p>
 * Clients can also access the entity owning the comments by using {@link Commentable#accept(CommentableVisitor)}.
 */
public interface CommentPropertyContext extends Iterable<Comment>, Commentable {

    /**
     * Adds a property to the {@code comment}. Any existing property stored under {@code key} will be replaced.
     *
     * @param comment the comment that will receive the new property
     * @param key property key
     * @param value property value
     */
    void setProperty(@Nonnull Comment comment, @Nonnull String key, @Nonnull Object value);
}
