package com.atlassian.bitbucket.build.server.operations;

import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.util.BuilderSupport;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * A request to perform an action on a build status e.g. run build, stop build.
 *
 * @since 7.8
 */
public final class BuildStatusActionRequest {

    private final BuildStatusAction buildStatusAction;
    private final RepositoryBuildStatus buildStatus;

    private BuildStatusActionRequest(Builder builder) {
        buildStatusAction = builder.buildStatusAction;
        buildStatus = builder.buildStatus;
    }

    /**
     * @return the {@link BuildStatusAction} to be performed
     */
    @Nonnull
    public BuildStatusAction getBuildAction() {
        return buildStatusAction;
    }

    /**
     * @return the {@link RepositoryBuildStatus} to perform the action on
     */
    @Nonnull
    public RepositoryBuildStatus getBuildStatus() {
        return buildStatus;
    }

    public static final class Builder extends BuilderSupport {

        private final RepositoryBuildStatus buildStatus;
        private final BuildStatusAction buildStatusAction;

        public Builder(@Nonnull BuildStatusAction buildStatusAction, @Nonnull RepositoryBuildStatus buildStatus) {
            this.buildStatusAction = requireNonNull(buildStatusAction, "buildAction");
            this.buildStatus = requireNonNull(buildStatus, "buildStatus");
        }

        @Nonnull
        public BuildStatusActionRequest build() {
            return new BuildStatusActionRequest(this);
        }
    }
}
