package com.atlassian.bitbucket.build.server.operations;

import javax.annotation.Nonnull;

/**
 * An action that can be performed on a build status
 *
 * @since 7.8
 */
public interface BuildStatusAction {

    /**
     * The identifier for this action.
     *
     * @return a unique identifying string for this action type
     */
    @Nonnull
    String getId();

    /**
     * The user readable name of the action, to display in the UI.
     *
     * @return a user-readable name for this action type
     */
    @Nonnull
    String getName();
}
