package com.atlassian.bitbucket.build.server.operations;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * Encapsulates the actions that can be taken as well as information about authorization requirements.
 *
 * @since 7.8
 */
public interface BuildOperations {

    /**
     * The {@link BuildStatusAction}s available for the currently authenticated user on this build status.
     *
     * @return the available {@link BuildStatusAction}s
     */
    @Nonnull
    List<BuildStatusAction> getActions();

    /**
     * Indicated whether or not the currently authenticated user has authorized Bitbucket to act on their behalf with
     * this build server.
     *
     * @return {@code true} if Bitbucket requires authorization. {@code false} if authorization has already been
     *         performed, or is not required for this build server.
     */
    boolean isAuthorizationRequired();
}
