package com.atlassian.bitbucket.build.server.operations;

import javax.annotation.Nonnull;
import java.util.Arrays;
import java.util.Optional;

import static java.util.Optional.empty;

/**
 * The final state of the request to perform an action.
 *
 * @since 7.8
 */
public enum ActionState {

    /**
     * An error occurred trying to perform the action, such as a connection error or the build server being down.
     * More detail should be provided in the {@link ActionResult#getMessage} about why it failed.
     */
    ERROR,
    /**
     * The action failed to perform. This may be because of a bad request, or a server error. More detail should be
     * provided in the {@link ActionResult#getMessage} about why it failed.
     */
    FAILED,
    /**
     * The action was performed successfully.
     */
    SUCCESSFUL;

    @Nonnull
    public static Optional<ActionState> fromString(String value) {
        if (value == null) {
            return empty();
        }
        return Arrays.stream(values())
                .filter(v -> v.name().equalsIgnoreCase(value))
                .findAny();
    }
}
