package com.atlassian.bitbucket.build.server.operations;

import javax.annotation.Nonnull;
import java.net.URI;
import java.util.Optional;

/**
 * The result of a request from Bitbucket to a CI system to perform a certain action.
 *
 * @since 7.8
 */
public interface ActionResult {

    /**
     * Optional additional message relating to the action invocation. For a failure it can contain additional information
     * about why it failed. For successful invocations it can contain additional information about the action.
     *
     * @return additional message if one is available
     */
    @Nonnull
    Optional<String> getMessage();

    /**
     * Returns the state of the action.
     *
     * @return final state of the action
     */
    @Nonnull
    ActionState getState();

    /**
     * Optional URI that can contain more information about the request. For a successful invocation it could be a link
     * to the new (if such is created) build. For failure it can contain a link with more information about the failure.
     *
     * @return uri for the action
     */
    @Nonnull
    Optional<URI> getURI();

}
