package com.atlassian.bitbucket.build.server;

import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;

/**
 * Module descriptor for providing {@link PluginBuildServerProvider} implementations.
 * <p>
 * Usage:
 * <pre><code>
 *     &lt;build-server-provider key="bamboo-build-server-provider"
 *                         class="com.atlassian.bitbucket.internal.build.bamboo.BambooBuildServerProvider"/&gt;
 * </code></pre>
 * The {@code key} and {@code class} attributes are <b>required</b>.
 *
 * @since 7.8
 */
public class
PluginBuildServerProviderModuleDescriptor extends AbstractModuleDescriptor<PluginBuildServerProvider> {

    public static final String XML_ELEMENT_NAME = "build-server-provider";

    private PluginBuildServerProvider module;

    public PluginBuildServerProviderModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Override
    public PluginBuildServerProvider getModule() {
        if (module == null) {
            module = moduleFactory.createModule(moduleClassName, this);
        }

        return module;
    }
}