package com.atlassian.bitbucket.build.server;

import com.atlassian.bitbucket.build.server.operations.PluginBuildServerClient;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;

import javax.annotation.Nonnull;
import java.net.URI;

/**
 * An abstraction describing a specific instance of a CI server and methods for Bitbucket Server to interact with it.
 *
 * @since 7.8
 */
public interface PluginBuildServer {

    /**
     * @return a {@link BuildStatusEnricher} that can be used to add extra details to a
     *         {@link RepositoryBuildStatus}
     */
    @Nonnull
    BuildStatusEnricher getBuildStatusEnricher();

    /**
     * @return a {@link PluginBuildServerClient} that can be used to interface with this build server
     */
    @Nonnull
    PluginBuildServerClient getClient();

    /**
     * Identifier that uniquely identifies this build server. This may be a URL, a UUID, or some other string.
     * It must identify the build server locally (within the scope of the provider) and additionally, as far
     * as possible, globally. As such a simple incrementing integer value would be a poor choice of identifier.
     *
     * @return an id that uniquely identifies this build server
     */
    @Nonnull
    String getId();

    /**
     * @return a human readable name for the build server
     */
    @Nonnull
    String getName();

    /**
     * @return the base URL to be used when constructing URIs to be used for RPC calls to this application.
     *         The returned {@link URI} will have no trailing slash. e.g. "http://localhost:6990/bamboo"
     */
    @Nonnull
    URI getRpcUrl();

    /**
     * Identifier of the type of the build server. For example, "bamboo" or "jenkins". For internal consumption
     * and not an i18n string.
     *
     * @return the id of the type of the build server
     */
    @Nonnull
    String getTypeId();
}
