package com.atlassian.bitbucket.build.server;

import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;

import javax.annotation.Nonnull;
import java.net.URI;
import java.util.Optional;

/**
 * A class that is used to add extra details to a {@link RepositoryBuildStatus} that don't exist in the database.
 *
 * @since 7.8
 */
public interface BuildStatusEnricher {

    /**
     * @param buildStatus the build status that the artifact link is associated with
     * @return a link to artifacts for this {@link RepositoryBuildStatus} or {@link Optional#empty()} if none exists
     */
    @Nonnull
    Optional<URI> getArtifactLink(@Nonnull RepositoryBuildStatus buildStatus);

    /**
     * @param buildStatus the build status that the log link is associated with
     * @return a link to the logs for this {@link RepositoryBuildStatus} or {@link Optional#empty()} if none exists
     */
    @Nonnull
    Optional<URI> getLogLink(@Nonnull RepositoryBuildStatus buildStatus);
}
