package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;

/**
 * Handler that is called when a user successfully authenticates with the system over SSH. The system will call
 * {@link #onAuthenticationSuccess(SshAuthenticationSuccessContext)} on all installed {@code ssh-auth-success-handler}
 * modules in order of their configured weight.
 * <p>
 * All {@code ssh-auth-success-handler} callbacks will be made in the {@link RequestContext context}
 * of the SSH command requested but will take place before the command is resolved to an {@link ScmRequest}
 * and before it is {@link ScmRequest#handleRequest() handled}.
 */
public interface SshAuthenticationSuccessHandler {

    /**
     * Callback method that is called by the system on authentication success over SSH. The authenticated
     * {@link ApplicationUser user} can be retrieved through {@link SshAuthenticationSuccessContext#getUser()}.
     *
     * @param context a context object holding authentication details and authenticated user.
     */
    void onAuthenticationSuccess(@Nonnull SshAuthenticationSuccessContext context);
}
