package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;

/**
 * Context class holding all details relevant for authentication success processing by
 * {@link SshAuthenticationSuccessHandler} modules.
 */
public interface SshAuthenticationSuccessContext extends SshAuthenticationContext {

    /**
     * @return the authenticated user
     */
    @Nonnull
    ApplicationUser getUser();

    /**
     * @return the SSH command string supplied by the client to be executed
     */
    @Nonnull
    String getCommand();
}
