package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.module.ModuleFactory;

/**
 * Module descriptor for custom ssh key authenticators.
 *
 * @see SshAuthenticationHandler
 */
public class SshAuthenticationHandlerModuleDescriptor extends BaseWeightedModuleDescriptor<SshAuthenticationHandler> {

    public static final String XML_ELEMENT_NAME = "ssh-auth-handler";

    private volatile SshAuthenticationHandler module;

    protected SshAuthenticationHandlerModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory, 50);
    }

    @Override
    public void disabled() {
        if (module instanceof StateAware) {
            ((StateAware) module).disabled();
        }
        module = null;

        super.disabled();
    }

    @Override
    public SshAuthenticationHandler getModule() {
        if (module == null) {
            module = moduleFactory.createModule(moduleClassName, this);

        }
        return module;
    }
}