package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.module.ModuleFactory;

public class SshAuthenticationFailureHandlerModuleDescriptor extends BaseWeightedModuleDescriptor<SshAuthenticationFailureHandler> {

    public static final String XML_ELEMENT_NAME = "ssh-auth-failure-handler";

    private volatile SshAuthenticationFailureHandler module;

    protected SshAuthenticationFailureHandlerModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory, 50);
    }

    @Override
    public void disabled() {
        if (module instanceof StateAware) {
            ((StateAware) module).disabled();
        }
        module = null;

        super.disabled();
    }

    @Override
    public SshAuthenticationFailureHandler getModule() {
        if (module == null) {
            module = moduleFactory.createModule(moduleClassName, this);

        }
        return module;
    }
}
