package com.atlassian.bitbucket.auth;

import javax.annotation.Nonnull;

/**
 * Handler for authentication failure over SSH.  {@link #onAuthenticationFailure(SshAuthenticationFailureContext)}
 * is called by the system for all installed {@code ssh-auth-failure-handler} module types, in order of their configured
 * weight (low to high).
 */
public interface SshAuthenticationFailureHandler {

    /**
     * A method called back on SSH authentication failure. The
     * {@link AuthenticationException reason} for authentication failure can be retrieved
     * through {@link SshAuthenticationFailureContext#getAuthenticationException()}.
     *
     * @param context a context object holding the authentication details and authentication exception.
     */
    void onAuthenticationFailure(@Nonnull SshAuthenticationFailureContext context);
}
