package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.scm.AuthenticationState;

import javax.annotation.Nonnull;

/**
 * Context class holding all details relevant for authentication failure processing by
 * {@link SshAuthenticationFailureHandler} modules.
 */
public interface SshAuthenticationFailureContext extends SshAuthenticationContext {

    /**
     * @return the exception that was thrown by the {@link SshAuthenticationHandler} that triggered authentication
     *         failure
     */
    @Nonnull
    AuthenticationException getAuthenticationException();

    /**
     * @return the state of authentication. Can be used to deduce the reason for authentication failure
     */
    @Nonnull
    AuthenticationState getAuthenticationState();
}
