package com.atlassian.bitbucket.auth;

import javax.annotation.Nonnull;
import java.security.PublicKey;

/**
 * The authentication context for SSH connections
 *
 * @see SshAuthenticationHandler
 */
public interface SshAuthenticationContext {

    /**
     * @return the provided username.
     */
    @Nonnull
    String getUsername();

    /**
     * @return the provided credentials.
     */
    @Nonnull
    PublicKey getPublicKey();
}
