package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Interface that {@code http-auth-handler} modules can optionally implement to receive callbacks on logout.
 */
public interface HttpLogoutHandler {

    /**
     * Implementations should clean up external resources if they need to. They can optionally write to the
     * response or redirect the user to override the standard system behaviour.
     *
     * @param user the user to log out
     * @param request the HTTP request
     * @param response the HTTP response
     */
    void logout(@Nonnull ApplicationUser user, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response);
}
