package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;

import static com.atlassian.plugin.util.validation.ValidationPattern.test;

public class HttpAuthenticationSuccessHandlerModuleDescriptor extends BaseWeightedModuleDescriptor<HttpAuthenticationSuccessHandler> {

    public static final String XML_ELEMENT_NAME = "http-auth-success-handler";

    private volatile HttpAuthenticationSuccessHandler module;

    protected HttpAuthenticationSuccessHandlerModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory, 50);
    }

    @Override
    public void disabled() {
        if (module instanceof StateAware) {
            ((StateAware) module).disabled();
        }
        module = null;

        super.disabled();
    }

    @Override
    public HttpAuthenticationSuccessHandler getModule() {
        if (module == null) {
            module = moduleFactory.createModule(moduleClassName, this);

        }
        return module;
    }

    @Override
    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(test("@class").withError("The class is required"));
    }
}
