package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import java.io.IOException;

/**
 * Handler that is called when a user successfully authenticates with the system over HTTP. The system will call
 * {@link #onAuthenticationSuccess(HttpAuthenticationSuccessContext)} on all installed {@code http-auth-success-handler}
 * modules in order of their configured weight, until a handler returns {@code true}.
 */
public interface HttpAuthenticationSuccessHandler {

    /**
     * Callback method that is called by the system on authentication success over HTTP. The authenticated
     * {@link ApplicationUser user} can be retrieved
     * through {@link HttpAuthenticationSuccessContext#getUser()}.
     * <p>
     * Implementations can prevent other success handlers further down the chain from being evaluated by returning
     * {@code true}. They should only do so if the handler has written to or redirected the HTTP response.
     *
     * @param context a context object holding the request, response, authentication details and authenticated user.
     * @return {@code true} if the request was fully handled and no other success handlers should be evaluated.
     *         Otherwise {@code false}.
     *
     * @throws ServletException may be thrown by implementations
     * @throws IOException      may be thrown by implementations
     */
    boolean onAuthenticationSuccess(@Nonnull HttpAuthenticationSuccessContext context) throws ServletException, IOException;
}
