package com.atlassian.bitbucket.auth;

import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import java.io.IOException;

/**
 * Handler for authentication failure over HTTP.
 * {@link HttpAuthenticationFailureHandler#onAuthenticationFailure(HttpAuthenticationFailureContext)} is called by the
 * system for all installed {@code http-auth-failure-handler} module types, in order of their configured weight (low to
 * high).
 */
public interface HttpAuthenticationFailureHandler {

    /**
     * Callback method that is called by the system on authentication failure. The
     * {@link AuthenticationException reason} for authentication failure can be retrieved
     * through {@link HttpAuthenticationFailureContext#getAuthenticationException()}.
     * <p>
     * Implementors can prevent other failure handlers further down the chain from being evaluated by returning
     * {@code true}. They should only do so if the handler has written to or redirected the HTTP response.
     *
     * @param context a context object holding the request, response, authentication details and authentication exception.
     * @return {@code true} if the request was fully handled and no other failure handlers should be evaluated.
     *         Otherwise {@code false}.
     *
     * @throws ServletException may be thrown by implementations
     * @throws IOException      may be thrown by implementations
     */
    boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws ServletException, IOException;
}
