package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.scm.AuthenticationState;

import javax.annotation.Nonnull;

/**
 * Context class holding all details relevant for authentication failure processing by
 * {@link HttpAuthenticationFailureHandler} modules.
 */
public interface HttpAuthenticationFailureContext extends HttpAuthenticationContext {

    /**
     * @return the state of authentication. Can be used to deduce the reason for authentication failure.
     */
    @Nonnull
    AuthenticationState getAuthenticationState();

    /**
     * @return the exception that was thrown by the {@link HttpAuthenticationHandler} that triggered authentication
     *         failure.
     */
    @Nonnull
    AuthenticationException getAuthenticationException();
}
