package com.atlassian.bitbucket.auth;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Context class holding all details relevant for authentication processing by {@link HttpAuthenticationHandler}
 * modules.
 */
public interface HttpAuthenticationContext {

    /**
     * BASIC authentication.
     */
    String METHOD_BASIC = "basic";
    /**
     * FORM-based authentication.
     */
    String METHOD_FORM = "form";
    /**
     * Authentication based on some kind of token (not username/password based).
     */
    String METHOD_TOKEN = "token";

    /**
     * @return the {@link FilterChain} for the authentication request.
     */
    @Nonnull
    FilterChain getFilterChain();

    /**
     * @return the HTTP request
     */
    @Nonnull
    HttpServletRequest getRequest();

    /**
     * @return the HTTP response
     */
    @Nonnull
    HttpServletResponse getResponse();

    /**
     * @return the provided username. Can be {@code null} if no username was provided. The provided username may be
     * different to the authenticated user's username, for example when using OAuth authentication.
     */
    @Nullable
    String getUsername();

    /**
     * @return the provided credentials. Can be {@code null} if no credentials were provided.
     */
    @Nullable
    Object getCredentials();

    /**
     * @return the requested authentication method. Can be either of {@link #METHOD_BASIC}, {@link #METHOD_FORM} or
     *         {@link #METHOD_TOKEN}.
     */
    @Nonnull
    String getMethod();
}
