/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScmUrlRequest {
    private final URI baseUrl;
    private final Repository repository;
    private final ApplicationUser user;

    private ScmUrlRequest(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.repository = builder.repository;
        this.user = builder.user;
    }

    @Nonnull
    public URI getBaseUrl() {
        return this.baseUrl;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public ApplicationUser getUser() {
        return this.user;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public static class Builder {
        private final URI baseUrl;
        private final Repository repository;
        private ApplicationUser user;

        public Builder(@Nonnull Repository repository, @Nonnull URI baseUrl) {
            this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl");
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        @Nonnull
        public ScmUrlRequest build() {
            return new ScmUrlRequest(this);
        }

        @Nonnull
        public Builder user(@Nullable ApplicationUser value) {
            this.user = value;
            return this;
        }
    }
}

