/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.throttle;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.atlassian.bitbucket.scm.ssh.SshScmRequest;
import com.atlassian.bitbucket.throttle.ThrottleService;
import com.atlassian.bitbucket.throttle.Ticket;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ThrottledScmRequestFactory {
    @VisibleForTesting
    static final String RESOURCE_NAME = "scm-hosting";
    private static final Logger log = LoggerFactory.getLogger(ThrottledScmRequestFactory.class);
    private final ThrottleService throttleService;

    public ThrottledScmRequestFactory(ThrottleService throttleService) {
        this.throttleService = Objects.requireNonNull(throttleService, "throttleService");
    }

    @Nonnull
    public SshScmRequest throttled(@Nonnull SshScmRequest request) {
        return new ThrottledSshScmRequest(request);
    }

    @Nonnull
    public HttpScmRequest throttled(@Nonnull HttpScmRequest request) {
        return new ThrottledHttpScmRequest(request);
    }

    private class ThrottledSshScmRequest
    extends AbstractThrottledScmRequest<SshScmRequest>
    implements SshScmRequest {
        private final Object lock;
        private volatile boolean canceledBeforeStart;
        private volatile boolean needsTicket;

        ThrottledSshScmRequest(SshScmRequest delegate) {
            super(ThrottledScmRequestFactory.this, (ScmRequest)delegate);
            this.lock = new Object();
            this.needsTicket = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (this.needsTicket) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.needsTicket) {
                        this.canceledBeforeStart = true;
                        log.debug("{} was canceled before request could be started", (Object)((SshScmRequest)this.delegate).getClass().getSimpleName());
                        return;
                    }
                }
            }
            ((SshScmRequest)this.delegate).cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleRequest() throws IOException {
            try (Ticket ignored = ThrottledScmRequestFactory.this.throttleService.acquireTicket(ThrottledScmRequestFactory.RESOURCE_NAME);){
                Object object = this.lock;
                synchronized (object) {
                    block19: {
                        if (!this.canceledBeforeStart) break block19;
                        log.trace("{} was canceled - nothing to start", (Object)((SshScmRequest)this.delegate).getClass().getSimpleName());
                        return;
                    }
                    this.needsTicket = false;
                }
                ((SshScmRequest)this.delegate).handleRequest();
            }
        }
    }

    private class ThrottledHttpScmRequest
    extends AbstractThrottledScmRequest<HttpScmRequest>
    implements HttpScmRequest {
        ThrottledHttpScmRequest(HttpScmRequest delegate) {
            super(ThrottledScmRequestFactory.this, (ScmRequest)delegate);
        }
    }

    private static abstract class AbstractThrottledScmRequest<T extends ScmRequest>
    implements ScmRequest {
        protected final T delegate;
        final /* synthetic */ ThrottledScmRequestFactory this$0;

        AbstractThrottledScmRequest(T delegate) {
            this.this$0 = var1_1;
            this.delegate = (ScmRequest)Objects.requireNonNull(delegate, "request");
        }

        @Override
        @Nonnull
        public Repository getRepository() {
            return this.delegate.getRepository();
        }

        @Override
        public void handleRequest() throws IOException {
            try (Ticket ignored = this.this$0.throttleService.acquireTicket(ThrottledScmRequestFactory.RESOURCE_NAME);){
                this.delegate.handleRequest();
            }
        }

        @Override
        public boolean isWrite() {
            return this.delegate.isWrite();
        }

        @Override
        public void sendError(@Nonnull String summary, @Nonnull String detailMessage) throws IOException {
            this.delegate.sendError(summary, detailMessage);
        }
    }
}

