/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.http;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RepositoryUrlFragment {
    private static final String SHORT_HOSTING_URL = "/?(?<projKey>[^/]+)/(?<repoSlug>[^/]+?)(?:\\.git)?+(?<restOfPath>/.*|$)";
    private static final String NAMESPACED_HOSTING_URL = "/?(?<namespace>[^/]+)/?(?<projKey>[^/]+)/(?<repoSlug>[^/]+?)(?:\\.git)?+(?<restOfPath>/.*|$)";
    private static final Pattern PATTERN_SHORT_HOSTING_URL = Pattern.compile("/?(?<projKey>[^/]+)/(?<repoSlug>[^/]+?)(?:\\.git)?+(?<restOfPath>/.*|$)");
    private static final Pattern PATTERN_NAMESPACED_HOSTING_URL = Pattern.compile("/?(?<namespace>[^/]+)/?(?<projKey>[^/]+)/(?<repoSlug>[^/]+?)(?:\\.git)?+(?<restOfPath>/.*|$)");
    private final String pathSuffix;
    private final String projectNamespace;
    private final String projectKey;
    private final String repositorySlug;

    private RepositoryUrlFragment(String projectNamespace, String projectKey, String repositorySlug, String pathSuffix) {
        this.pathSuffix = StringUtils.trimToNull((String)pathSuffix);
        this.projectNamespace = StringUtils.trimToNull((String)projectNamespace);
        this.projectKey = Objects.requireNonNull(projectKey, "projectKey");
        this.repositorySlug = Objects.requireNonNull(repositorySlug, "repositorySlug");
    }

    @Nullable
    public static RepositoryUrlFragment fromPathInfo(@Nonnull String pathInfo) {
        Matcher m = PATTERN_SHORT_HOSTING_URL.matcher((CharSequence)Preconditions.checkNotNull((Object)pathInfo, (Object)"pathInfo"));
        return m.find() ? new RepositoryUrlFragment(null, m.group("projKey"), m.group("repoSlug"), m.group("restOfPath")) : null;
    }

    @Nullable
    public static RepositoryUrlFragment fromNamespacedPathInfo(@Nonnull String pathInfo) {
        Matcher m = PATTERN_NAMESPACED_HOSTING_URL.matcher((CharSequence)Preconditions.checkNotNull((Object)pathInfo, (Object)"pathInfo"));
        return m.find() ? new RepositoryUrlFragment(m.group("namespace"), m.group("projKey"), m.group("repoSlug"), m.group("restOfPath")) : null;
    }

    @Nonnull
    public static RepositoryUrlFragment fromRepository(@Nonnull Repository repository) {
        Project project = ((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getProject();
        String projectNamespace = ((Project)Preconditions.checkNotNull((Object)project, (Object)"repository.project")).getNamespace();
        String projectKey = project.getKey();
        return new RepositoryUrlFragment(projectNamespace, projectKey, repository.getSlug(), null);
    }

    @Nullable
    public String getPathSuffix() {
        return this.pathSuffix;
    }

    @Nonnull
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nullable
    public String getProjectNamespace() {
        return this.projectNamespace;
    }

    @Nonnull
    public String getRepositorySlug() {
        return this.repositorySlug;
    }

    @Nonnull
    public String toPath(@Nullable String basePath) {
        StringBuilder builder = new StringBuilder();
        if (basePath == null) {
            builder.append('/');
        } else {
            builder.append(basePath);
            if (!basePath.endsWith("/")) {
                builder.append('/');
            }
        }
        return builder.append(this.toPath()).toString();
    }

    @Nonnull
    public String toString() {
        return this.toPath();
    }

    private String toPath() {
        StringBuilder sb = new StringBuilder();
        if (this.projectNamespace != null) {
            sb.append(this.projectNamespace);
            sb.append('/');
        }
        sb.append(this.projectKey);
        sb.append('/');
        sb.append(this.repositorySlug);
        return sb.toString().toLowerCase(Locale.ROOT);
    }
}

