/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.scm.AsyncCommand;
import com.atlassian.bitbucket.scm.Command;
import java.util.OptionalLong;
import javax.annotation.Nonnull;

abstract class AbstractCompatibilityCommand<T>
implements Command<T> {
    private OptionalLong executionTimeout = OptionalLong.empty();
    private OptionalLong idleTimeout = OptionalLong.empty();

    @Nonnull
    public AsyncCommand<T> asynchronous() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support asynchronous execution.");
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = OptionalLong.of(executionTimeout);
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = OptionalLong.of(idleTimeout);
    }

    protected <C> C configureAndCall(Command<C> command) {
        this.executionTimeout.ifPresent(arg_0 -> command.setExecutionTimeout(arg_0));
        this.idleTimeout.ifPresent(arg_0 -> command.setIdleTimeout(arg_0));
        return (C)command.call();
    }
}

