/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.http;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryUrlFragment {
    private static final String SHORT_HOSTING_URL = "/([^/]+)/([^/]+?)(?:\\.git)?+(?:/.*|$)";
    private static final String NAMESPACED_HOSTING_URL = "/([^/]+)/([^/]+)/([^/]+?)(?:\\.git)?+(?:/.*|$)";
    private static final Pattern PATTERN_SHORT_HOSTING_URL = Pattern.compile("/([^/]+)/([^/]+?)(?:\\.git)?+(?:/.*|$)");
    private static final Pattern PATTERN_NAMESPACED_HOSTING_URL = Pattern.compile("/([^/]+)/([^/]+)/([^/]+?)(?:\\.git)?+(?:/.*|$)");
    private final String projectNamespace;
    private final String projectKey;
    private final String repositorySlug;

    private RepositoryUrlFragment(String projectNamespace, String projectKey, String repositorySlug) {
        this.projectNamespace = projectNamespace;
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
    }

    @Nullable
    public static RepositoryUrlFragment fromPathInfo(@Nonnull String pathInfo) {
        Matcher m = PATTERN_SHORT_HOSTING_URL.matcher((CharSequence)Preconditions.checkNotNull((Object)pathInfo, (Object)"pathInfo"));
        return m.find() ? new RepositoryUrlFragment(null, m.group(1), m.group(2)) : null;
    }

    @Nullable
    public static RepositoryUrlFragment fromNamespacedPathInfo(@Nonnull String pathInfo) {
        Matcher m = PATTERN_NAMESPACED_HOSTING_URL.matcher((CharSequence)Preconditions.checkNotNull((Object)pathInfo, (Object)"pathInfo"));
        return m.find() ? new RepositoryUrlFragment(m.group(1), m.group(2), m.group(3)) : null;
    }

    @Nonnull
    public static RepositoryUrlFragment fromRepository(@Nonnull Repository repository) {
        Project project = ((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getProject();
        String projectNamespace = ((Project)Preconditions.checkNotNull((Object)project, (Object)"repository.project")).getNamespace();
        String projectKey = project.getKey();
        return new RepositoryUrlFragment(projectNamespace, projectKey, repository.getSlug());
    }

    @Nonnull
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nullable
    public String getProjectNamespace() {
        return this.projectNamespace;
    }

    @Nonnull
    public String getRepositorySlug() {
        return this.repositorySlug;
    }

    @Nonnull
    public String toPath(@Nullable String basePath) {
        StringBuilder builder = new StringBuilder();
        if (basePath == null) {
            builder.append('/');
        } else {
            builder.append(basePath);
            if (!basePath.endsWith("/")) {
                builder.append('/');
            }
        }
        return builder.append(this.toPath()).toString();
    }

    @Nonnull
    public String toString() {
        return this.toPath();
    }

    private String toPath() {
        String path = this.projectNamespace == null ? this.projectKey + "/" + this.repositorySlug : this.projectNamespace + "/" + this.projectKey + "/" + this.repositorySlug;
        return path.toLowerCase(Locale.US);
    }
}

