/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook;

import com.atlassian.bitbucket.hook.HookRequestHandle;
import com.atlassian.bitbucket.scm.CommandBuilder;
import com.atlassian.utils.process.ExternalProcessSettings;
import java.util.Map;
import javax.annotation.Nonnull;

public class HookUtils {
    private HookUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static void configure(@Nonnull HookRequestHandle requestHandle, @Nonnull ExternalProcessSettings settings) {
        HookUtils.configureEnvironment(requestHandle, settings.getEnvironment());
    }

    public static void configure(@Nonnull HookRequestHandle requestHandle, @Nonnull ProcessBuilder builder) {
        HookUtils.configureEnvironment(requestHandle, builder.environment());
    }

    public static void configure(@Nonnull HookRequestHandle requestHandle, @Nonnull CommandBuilder commandBuilder) {
        commandBuilder.environment("STASH_HOOK_CALLBACK", requestHandle.getCallbackScript().getAbsolutePath()).environment("STASH_HOOK_COORDINATOR", requestHandle.getCoordinatorScript().getAbsolutePath()).environment("STASH_HOOK_ADDRESS", requestHandle.getHostAddress()).environment("STASH_HOOK_PORT", Integer.toString(requestHandle.getPort())).environment("STASH_HOOK_REQUEST_ID", requestHandle.getRequestId());
    }

    private static void configureEnvironment(@Nonnull HookRequestHandle requestHandle, @Nonnull Map<String, String> environment) {
        environment.put("STASH_HOOK_CALLBACK", requestHandle.getCallbackScript().getAbsolutePath());
        environment.put("STASH_HOOK_COORDINATOR", requestHandle.getCoordinatorScript().getAbsolutePath());
        environment.put("STASH_HOOK_ADDRESS", requestHandle.getHostAddress());
        environment.put("STASH_HOOK_PORT", Integer.toString(requestHandle.getPort()));
        environment.put("STASH_HOOK_REQUEST_ID", requestHandle.getRequestId());
    }
}

