/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.pull;

import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeOutcome;
import com.atlassian.bitbucket.pull.PullRequestMergeResult;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.SimpleCommand;
import com.atlassian.bitbucket.scm.pull.BulkRescopeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestChangeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDiffCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.scm.pull.PullRequestMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.RepositoryRescopeCommandParameters;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface PluginPullRequestCommandFactory {
    @Nonnull
    default public Command<Void> bulkRescope(@Nonnull BulkRescopeCommandParameters parameters) {
        throw new UnsupportedOperationException(parameters.getRepository().getScmId() + " does not support bulk rescope (yet)");
    }

    @Nonnull
    @Deprecated
    public Command<Boolean> canMerge(@Nonnull PullRequest var1);

    @Nonnull
    public Command<Void> changes(@Nonnull PullRequest var1, @Nonnull PullRequestChangeCommandParameters var2, @Nonnull ChangeCallback var3);

    @Nonnull
    public Command<Void> commits(@Nonnull PullRequest var1, @Nonnull CommitCallback var2);

    @Nonnull
    public Command<Void> diff(@Nonnull PullRequest var1, @Nonnull PullRequestDiffCommandParameters var2, @Nonnull DiffContentCallback var3);

    @Nonnull
    public Command<PullRequestEffectiveDiff> effectiveDiff(@Nonnull PullRequest var1);

    @Nonnull
    public Command<Branch> merge(@Nonnull PullRequest var1, @Nonnull PullRequestMergeCommandParameters var2);

    @Deprecated
    @Nonnull
    default public Command<Void> rescope(@Nonnull RepositoryRescopeCommandParameters parameters) {
        throw new UnsupportedOperationException(parameters.getRepository().getScmId() + " has migrated to supporting bulkRescope instead");
    }

    @Nonnull
    default public Command<PullRequestMergeResult> tryMerge(final @Nonnull PullRequest pullRequest) {
        return new SimpleCommand<PullRequestMergeResult>(){

            @Nonnull
            public PullRequestMergeResult call() {
                PullRequestMergeOutcome outcome = Optional.ofNullable(PluginPullRequestCommandFactory.this.canMerge(pullRequest).call()).map(canMerge -> canMerge != false ? PullRequestMergeOutcome.CLEAN : PullRequestMergeOutcome.CONFLICTED).orElse(PullRequestMergeOutcome.UNKNOWN);
                return new PullRequestMergeResult.Builder(outcome).build();
            }
        };
    }
}

