/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.bitbucket.util.Weighted;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class BaseScmHookModuleDescriptor<T>
extends BaseWeightedModuleDescriptor<T> {
    private static final int DEFAULT_WEIGHT = 1000;
    private static final Function<ModuleDescriptor, String> TO_MODULE_KEY = input -> null == input ? "" : input.getCompleteKey();
    private static final Ordering MODULE_KEY_ORDERING = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsLast().onResultOf(TO_MODULE_KEY::apply);
    private T module;

    public BaseScmHookModuleDescriptor(@Nonnull ModuleFactory moduleFactory) {
        super(moduleFactory, 1000);
    }

    @Override
    public int compareTo(@Nonnull BaseWeightedModuleDescriptor<T> otherDescriptor) {
        return Ordering.from(Weighted.COMPARABLE).compound((Comparator)MODULE_KEY_ORDERING).compare((Object)this, otherDescriptor);
    }

    public T getModule() {
        return this.module;
    }

    public void enabled() {
        super.enabled();
        this.module = this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }
}

