/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;

public class TransactionBatcher {
    private final PlatformTransactionManager transactionManager;
    private final int batchSize;
    private final String identifier;
    private TransactionStatus tx;
    private int count = 0;

    public TransactionBatcher(PlatformTransactionManager transactionManager, int batchSize, String identifier) {
        this.transactionManager = transactionManager;
        this.batchSize = batchSize;
        this.identifier = identifier;
    }

    public boolean tick() {
        boolean ticked;
        boolean bl = ticked = ++this.count % this.batchSize == 0;
        if (ticked) {
            this.commit();
            this.start();
        }
        return ticked;
    }

    public void start() {
        DefaultTransactionAttribute def = new DefaultTransactionAttribute();
        def.setName("TransactionBatch:" + this.identifier + ":" + this.count);
        def.setPropagationBehavior(3);
        this.tx = this.transactionManager.getTransaction((TransactionDefinition)def);
    }

    public void commit() {
        this.transactionManager.commit(this.tx);
        this.tx = null;
    }

    public boolean rollback() {
        if (this.tx != null && !this.tx.isCompleted()) {
            this.transactionManager.rollback(this.tx);
            return true;
        }
        return false;
    }

    public int getCount() {
        return this.count;
    }
}

