/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.event.auth.AuthenticationSuccessEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.user.InternalUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAuthenticationTracker {
    private static final Logger log = LoggerFactory.getLogger(UserAuthenticationTracker.class);
    private final InternalUserService userService;

    @Autowired
    public UserAuthenticationTracker(InternalUserService userService) {
        this.userService = userService;
    }

    @EventListener
    public void onAuthenticationSuccess(AuthenticationSuccessEvent event) {
        String username = event.getUsername();
        if (username != null) {
            try {
                this.userService.updateLastAuthentication(username);
            }
            catch (EntityOutOfDateException entityOutOfDateException) {
            }
            catch (RuntimeException e) {
                log.warn("{}: Failed to update last authentication timestamp", (Object)username, (Object)e);
            }
        }
    }
}

