/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.event.permission.PermissionEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionGrantedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionModifiedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionRevokedEvent;
import com.atlassian.bitbucket.event.project.ProjectDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.user.GroupCleanupEvent;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.permission.EffectivePermission;
import com.atlassian.bitbucket.permission.EffectivePermissionsChangedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Pair;
import com.atlassian.stash.internal.user.DefaultPermissionGraph;
import com.atlassian.stash.internal.user.EffectivePermissionDao;
import com.atlassian.stash.internal.user.EffectivePermissionGraphFactoryBase;
import com.atlassian.stash.internal.user.EffectivePermissionsProviderTracker;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.InternalUserUtils;
import com.atlassian.stash.internal.user.IterablePermissionGraph;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.hazelcast.core.IMap;
import com.hazelcast.map.AbstractEntryProcessor;
import com.hazelcast.map.EntryProcessor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class InternalUserPermissionGraphFactory
extends EffectivePermissionGraphFactoryBase {
    private static final Logger log = LoggerFactory.getLogger(InternalUserPermissionGraphFactory.class);
    private static final String DEFAULT_KEY = "default";
    private final IMap<String, DefaultPermissionGraph> defaultPermissions;
    private final Function<String, DefaultPermissionGraph> defaultPermissionsLoader;
    private final IMap<String, DefaultPermissionGraph> groupPermissions;
    private final Function<String, DefaultPermissionGraph> groupPermissionsLoader;
    private final EffectivePermissionDao effectivePermissionDao;
    private final ProjectPermissionDao projectPermissionDao;
    private final IMap<Integer, DefaultPermissionGraph> userPermissions;
    private final Function<Integer, DefaultPermissionGraph> userPermissionsLoader;
    private int maxGrantedPermissionsPageSize;
    private UserService userService;
    private volatile long cacheVersion;

    @Autowired
    public InternalUserPermissionGraphFactory(IMap<String, DefaultPermissionGraph> defaultPermissions, IMap<String, DefaultPermissionGraph> groupPermissions, IMap<Integer, DefaultPermissionGraph> userPermissions, EffectivePermissionDao effectivePermissionDao, ProjectPermissionDao projectPermissionDao, EffectivePermissionsProviderTracker permissionsProviderTracker) {
        super(permissionsProviderTracker);
        this.defaultPermissions = defaultPermissions;
        this.groupPermissions = groupPermissions;
        this.effectivePermissionDao = effectivePermissionDao;
        this.projectPermissionDao = projectPermissionDao;
        this.userPermissions = userPermissions;
        this.defaultPermissionsLoader = this.createDefaultPermissionsLoader();
        this.groupPermissionsLoader = this.createGroupPermissionsLoader();
        this.userPermissionsLoader = this.createUserPermissionsLoader();
        this.maxGrantedPermissionsPageSize = 1000;
    }

    @Nonnull
    public IterablePermissionGraph createGraph(@Nonnull ApplicationUser user) {
        Preconditions.checkArgument((boolean)InternalUserUtils.isInternalUser(user), (Object)"This factory can only create graphs for internal user");
        return new RecalculatingPermissionGraph(user);
    }

    @EventListener
    public void onGroupCleanup(GroupCleanupEvent event) {
        this.invalidate(this.groupPermissions, IdentifierUtils.toLowerCase((String)event.getGroup()));
    }

    @EventListener
    public void onEffectivePermissionsChanged(EffectivePermissionsChangedEvent event) {
        this.markCacheUpdated();
    }

    @EventListener
    public void onPermissionsChanged(PermissionEvent event) {
        if (event instanceof CancelableEvent) {
            return;
        }
        ApplicationUser user = event.getAffectedUser();
        String group = event.getAffectedGroup();
        if (user != null) {
            this.invalidate(this.userPermissions, user.getId());
        } else if (StringUtils.isNotBlank((CharSequence)group)) {
            this.invalidate(this.groupPermissions, IdentifierUtils.toLowerCase((String)group));
        } else if (event instanceof ProjectPermissionEvent) {
            Project project = ((ProjectPermissionEvent)event).getProject();
            if (event instanceof ProjectPermissionGrantedEvent) {
                this.updateDefaultPermission(project, event.getPermission());
            } else if (event instanceof ProjectPermissionRevokedEvent) {
                this.updateDefaultPermission(project, null);
            } else if (event instanceof ProjectPermissionModifiedEvent) {
                this.updateDefaultPermission(project, event.getPermission());
            }
        }
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) {
        this.updateDefaultPermission(event.getProject(), null);
        this.invalidateAll(this.userPermissions);
        this.invalidateAll(this.groupPermissions);
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.invalidateAll(this.userPermissions);
        this.invalidateAll(this.groupPermissions);
    }

    @EventListener
    public void onUserCleanup(UserCleanupEvent event) {
        ApplicationUser deletedUser = event.getDeletedUser();
        if (deletedUser != null) {
            this.invalidate(this.userPermissions, deletedUser.getId());
        }
    }

    @Value(value="${page.max.granted.permissions}")
    public void setMaxGrantedPermissionsPageSize(int maxGrantedPermissionsPageSize) {
        this.maxGrantedPermissionsPageSize = maxGrantedPermissionsPageSize;
    }

    public void warmCaches() {
        this.getDefaultPermissions();
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    private Function<String, DefaultPermissionGraph> createDefaultPermissionsLoader() {
        return new Function<String, DefaultPermissionGraph>(){

            public DefaultPermissionGraph apply(String key) {
                return new DefaultPermissionGraph.Builder().addInternalPermissions((Iterable<? extends InternalGrantedPermission>)new PagedIterable((PageProvider)new PageProvider<InternalProjectPermission>(){

                    public Page<InternalProjectPermission> get(PageRequest request) {
                        return InternalUserPermissionGraphFactory.this.projectPermissionDao.findDefaultPermissions(request);
                    }
                }, InternalUserPermissionGraphFactory.this.maxGrantedPermissionsPageSize)).build();
            }
        };
    }

    private Function<String, DefaultPermissionGraph> createGroupPermissionsLoader() {
        return new Function<String, DefaultPermissionGraph>(){

            public DefaultPermissionGraph apply(final String group) {
                return new DefaultPermissionGraph.Builder().addInternalPermissions((Iterable<? extends InternalGrantedPermission>)new PagedIterable((PageProvider)new PageProvider<InternalGrantedPermission>(){

                    public Page<InternalGrantedPermission> get(PageRequest request) {
                        return InternalUserPermissionGraphFactory.this.effectivePermissionDao.findByGroup(group, request);
                    }
                }, InternalUserPermissionGraphFactory.this.maxGrantedPermissionsPageSize)).build();
            }
        };
    }

    private Function<Integer, DefaultPermissionGraph> createUserPermissionsLoader() {
        return new Function<Integer, DefaultPermissionGraph>(){

            public DefaultPermissionGraph apply(final Integer userId) {
                return new DefaultPermissionGraph.Builder().addInternalPermissions((Iterable<? extends InternalGrantedPermission>)new PagedIterable((PageProvider)new PageProvider<InternalGrantedPermission>(){

                    public Page<InternalGrantedPermission> get(PageRequest request) {
                        return InternalUserPermissionGraphFactory.this.effectivePermissionDao.findByUserId(userId, request);
                    }
                }, InternalUserPermissionGraphFactory.this.maxGrantedPermissionsPageSize)).build();
            }
        };
    }

    private DefaultPermissionGraph getDefaultPermissions() {
        return this.getPermissionGraph(this.defaultPermissions, DEFAULT_KEY, this.defaultPermissionsLoader);
    }

    private DefaultPermissionGraph getGroupsPermissions(Iterable<String> groups) {
        DefaultPermissionGraph.Builder builder = new DefaultPermissionGraph.Builder();
        for (String group : groups) {
            builder.addGraph(this.getPermissionGraph(this.groupPermissions, IdentifierUtils.toLowerCase((String)group), this.groupPermissionsLoader));
        }
        return builder.build();
    }

    private <K> DefaultPermissionGraph getPermissionGraph(IMap<K, DefaultPermissionGraph> cache, K key, Function<K, DefaultPermissionGraph> loader) {
        DefaultPermissionGraph graph = (DefaultPermissionGraph)cache.get(key);
        while (graph == null) {
            graph = (DefaultPermissionGraph)Preconditions.checkNotNull((Object)loader.apply(key), (Object)"cache loader returned a null value!");
            DefaultPermissionGraph other = (DefaultPermissionGraph)cache.putIfAbsent(key, (Object)graph);
            if (other == null || other.equals(graph)) continue;
            cache.delete(key);
            graph = null;
        }
        return graph;
    }

    private DefaultPermissionGraph getUserPermissions(Integer userId) {
        return this.getPermissionGraph(this.userPermissions, userId, this.userPermissionsLoader);
    }

    private Iterable<String> loadGroupsByUser(final ApplicationUser user) {
        Preconditions.checkArgument((user.getType() == UserType.NORMAL ? 1 : 0) != 0, (Object)"only normal users have groups");
        return new PagedIterable((PageProvider)new PageProvider<String>(){

            public Page<String> get(PageRequest request) {
                return InternalUserPermissionGraphFactory.this.userService.findGroupsByUser(user.getName(), request);
            }
        }, this.maxGrantedPermissionsPageSize);
    }

    public boolean cacheInvalidatedSince(long version) {
        return this.cacheVersion != version;
    }

    private <K> void invalidate(IMap<K, DefaultPermissionGraph> cache, K key) {
        cache.delete(key);
        this.markCacheUpdated();
    }

    private void invalidateAll(IMap<?, DefaultPermissionGraph> cache) {
        cache.clear();
        this.markCacheUpdated();
    }

    private void markCacheUpdated() {
        ++this.cacheVersion;
    }

    private void updateDefaultPermission(Project project, Permission newPermission) {
        this.defaultPermissions.executeOnKey((Object)DEFAULT_KEY, (EntryProcessor)new DefaultPermissionsUpdatingEntryProcessor(project, newPermission));
        this.markCacheUpdated();
    }

    private class ServiceUserPermissionGraphCalculator
    implements PermissionGraphCalculator {
        private final ServiceUser user;

        private ServiceUserPermissionGraphCalculator(ServiceUser user) {
            this.user = user;
        }

        @Override
        public IterablePermissionGraph calculate() {
            return new DefaultPermissionGraph.Builder().addGraph(InternalUserPermissionGraphFactory.this.getUserPermissions(this.user.getId())).addEffectivePermissions(InternalUserPermissionGraphFactory.this.getEffectivePermissions((ApplicationUser)this.user)).add(Permission.LICENSED_USER, null).build();
        }
    }

    private class NormalUserPermissionGraphCalculator
    implements PermissionGraphCalculator {
        private final ApplicationUser user;

        private NormalUserPermissionGraphCalculator(ApplicationUser user) {
            this.user = user;
        }

        @Override
        public IterablePermissionGraph calculate() {
            return new DefaultPermissionGraph.Builder().addGraph(InternalUserPermissionGraphFactory.this.getDefaultPermissions()).addGraph(InternalUserPermissionGraphFactory.this.getGroupsPermissions(InternalUserPermissionGraphFactory.this.loadGroupsByUser(this.user))).addGraph(InternalUserPermissionGraphFactory.this.getUserPermissions(this.user.getId())).addEffectivePermissions(InternalUserPermissionGraphFactory.this.getEffectivePermissions(this.user)).build();
        }
    }

    private static class DefaultPermissionsUpdatingEntryProcessor
    extends AbstractEntryProcessor<String, DefaultPermissionGraph>
    implements Externalizable {
        private int projectId;
        private Permission newPermission;

        public DefaultPermissionsUpdatingEntryProcessor() {
        }

        private DefaultPermissionsUpdatingEntryProcessor(Project project, Permission newPermission) {
            this.projectId = project.getId();
            this.newPermission = newPermission;
        }

        public Object process(Map.Entry<String, DefaultPermissionGraph> entry) {
            DefaultPermissionGraph.Builder builder = new DefaultPermissionGraph.Builder();
            if (entry.getValue() != null) {
                builder.addGraph(entry.getValue()).clearAllForProject(this.projectId);
            }
            if (this.newPermission != null) {
                builder.add(this.newPermission, this.projectId);
            }
            entry.setValue(builder.build());
            return null;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.projectId = in.readInt();
            this.newPermission = (Permission)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.projectId);
            out.writeObject(this.newPermission);
        }
    }

    private class RecalculatingPermissionGraph
    implements IterablePermissionGraph {
        private final PermissionGraphCalculator calculator;
        private final ApplicationUser user;
        private volatile Pair<IterablePermissionGraph, Long> graphAndVersion;

        private RecalculatingPermissionGraph(ApplicationUser user) {
            this.user = user;
            this.calculator = this.newCalculatorForUserType(user);
            this.graphAndVersion = this.recalculate();
        }

        public boolean isGranted(Permission permission, @Nullable Object resource) {
            return this.getGraph().isGranted(permission, resource);
        }

        public Iterator<EffectivePermission> iterator() {
            return this.getGraph().iterator();
        }

        private IterablePermissionGraph getGraph() {
            if (InternalUserPermissionGraphFactory.this.cacheInvalidatedSince((Long)this.graphAndVersion.right())) {
                log.debug("Permission graph for user {} has expired and will be recalculated", (Object)this.user.getName());
                this.graphAndVersion = this.recalculate();
            }
            return (IterablePermissionGraph)this.graphAndVersion.left();
        }

        private PermissionGraphCalculator newCalculatorForUserType(ApplicationUser stashUser) {
            return (PermissionGraphCalculator)stashUser.accept((ApplicationUserVisitor)new AbstractApplicationUserVisitor<PermissionGraphCalculator>(){

                public PermissionGraphCalculator visit(@Nonnull DetailedUser user) {
                    return this.visit((ApplicationUser)user);
                }

                public PermissionGraphCalculator visit(@Nonnull ServiceUser user) {
                    return new ServiceUserPermissionGraphCalculator(user);
                }

                public PermissionGraphCalculator visit(@Nonnull ApplicationUser user) {
                    return new NormalUserPermissionGraphCalculator(user);
                }
            });
        }

        private Pair<IterablePermissionGraph, Long> recalculate() {
            long currentVersion = InternalUserPermissionGraphFactory.this.cacheVersion;
            return Pair.pair((Object)this.calculator.calculate(), (Object)currentVersion);
        }
    }

    private static interface PermissionGraphCalculator {
        public IterablePermissionGraph calculate();
    }
}

