/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.user.PasswordResetHelper;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="passwordResetHelper")
public class CrowdPasswordResetHelper
implements PasswordResetHelper {
    public static final String PASSWORD_RESET_TOKEN_ATTRIBUTE = "passwordResetToken";
    public static final Property<String> PASSWORD_RESET_PROPERTY = PropertyUtils.ofTypeString((String)"passwordResetToken");
    public static final String PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE = "passwordResetExpiration";
    private final CrowdControl crowdControl;
    private final SecureTokenGenerator tokenGenerator;
    private final long tokenValidityPeriod;

    @Autowired
    public CrowdPasswordResetHelper(CrowdControl crowdControl, SecureTokenGenerator tokenGenerator, @Value(value="${password.reset.validity.period}") int tokenValidityPeriod) {
        this.crowdControl = crowdControl;
        this.tokenGenerator = tokenGenerator;
        this.tokenValidityPeriod = TimeUnit.MINUTES.toMillis(tokenValidityPeriod);
    }

    @Override
    public String addResetPasswordToken(User user) {
        String token = this.tokenGenerator.generateToken();
        this.crowdControl.setUserAttribute(user, PASSWORD_RESET_TOKEN_ATTRIBUTE, (Object)token);
        this.crowdControl.setUserAttribute(user, PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE, (Object)(System.currentTimeMillis() + this.tokenValidityPeriod));
        return token;
    }

    @Override
    public User findUserByResetToken(String token) {
        User user = this.crowdControl.findUserByProperty(PASSWORD_RESET_PROPERTY, (Object)token);
        if (user != null) {
            UserWithAttributes userWithAttributes = this.crowdControl.findUserWithAttributes(user.getName());
            return userWithAttributes != null && this.getPasswordToken(userWithAttributes) != null ? userWithAttributes : null;
        }
        return null;
    }

    @Override
    public String generatePassword() {
        return this.tokenGenerator.generateToken();
    }

    @Override
    public String getPasswordToken(UserWithAttributes user) {
        String token = user.getValue(PASSWORD_RESET_TOKEN_ATTRIBUTE);
        long expiration = NumberUtils.toLong((String)user.getValue(PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE));
        return token != null && expiration >= System.currentTimeMillis() ? token : null;
    }

    @Override
    public void resetPassword(User user, String password) {
        this.crowdControl.setPassword(user, password);
        this.crowdControl.removeUserAttribute(user, PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE);
        this.crowdControl.removeUserAttribute(user, PASSWORD_RESET_TOKEN_ATTRIBUTE);
    }
}

