/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.pull.MinimalPullRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalRescopeRequest;
import com.atlassian.stash.internal.pull.rescope.SimpleMinimalPullRequest;
import com.atlassian.stash.internal.pull.rescope.SimplePullRequestRescope;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestRescopeChain {
    private static final Logger log = LoggerFactory.getLogger(PullRequestRescopeChain.class);
    private static final String NULL_SHA = "0000000000000000000000000000000000000000";
    private final SimpleMinimalPullRequest pullRequest;
    private final List<SimplePullRequestRescope> rescopes;

    private PullRequestRescopeChain(Builder builder) {
        this.pullRequest = builder.pullRequest;
        this.rescopes = builder.buildRescopes();
    }

    @Nonnull
    public SimpleMinimalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public List<SimplePullRequestRescope> getRescopes() {
        return this.rescopes;
    }

    private static String describe(MinimalPullRequest pullRequest) {
        return pullRequest.getFromRef().getRepository() + "#" + pullRequest.getId();
    }

    private static String describe(MinimalRefChange change) {
        return change == null ? "unchanged" : change.toString();
    }

    private static boolean hasGap(String hash, MinimalRefChange change) {
        return change != null && !ShaUtils.hashesMatch((String)change.oldHash, (String)hash);
    }

    private static class GapSegment
    extends Segment {
        GapSegment(MinimalRefChange fromRefChange, MinimalRefChange toRefChange) {
            super(fromRefChange, toRefChange);
        }

        GapSegment merge(GapSegment other) {
            return new GapSegment(MinimalRefChange.merge(this.fromRefChange, other.fromRefChange), MinimalRefChange.merge(this.toRefChange, other.toRefChange));
        }

        public String toString() {
            return "{gap from-ref: " + PullRequestRescopeChain.describe(this.fromRefChange) + ", to-ref: " + PullRequestRescopeChain.describe(this.toRefChange) + "}";
        }
    }

    private static class AttributedSegment
    extends Segment {
        private final Date date;
        private final ApplicationUser user;

        AttributedSegment(Date date, ApplicationUser user, MinimalRefChange fromChange, MinimalRefChange toChange) {
            super(fromChange, toChange);
            this.date = date;
            this.user = user;
        }

        public String toString() {
            return "{attributed-segment from-ref: " + PullRequestRescopeChain.describe(this.fromRefChange) + ", to-ref: " + PullRequestRescopeChain.describe(this.toRefChange) + ", user: " + this.user.getName() + ", date: " + this.date + "}";
        }
    }

    private static abstract class Segment {
        protected final MinimalRefChange fromRefChange;
        protected final MinimalRefChange toRefChange;

        Segment(MinimalRefChange fromRefChange, MinimalRefChange toRefChange) {
            this.fromRefChange = fromRefChange;
            this.toRefChange = toRefChange;
        }

        public String getNewFromHash() {
            return this.fromRefChange == null ? null : this.fromRefChange.newHash;
        }

        public String getNewToHash() {
            return this.toRefChange == null ? null : this.toRefChange.newHash;
        }

        public String getOldFromHash() {
            return this.fromRefChange == null ? null : this.fromRefChange.oldHash;
        }

        public String getOldToHash() {
            return this.toRefChange == null ? null : this.toRefChange.oldHash;
        }
    }

    private static class MinimalRefChange {
        private final String oldHash;
        private final String newHash;

        public MinimalRefChange(@Nonnull String oldHash, @Nonnull String newHash) {
            this.oldHash = Objects.requireNonNull(oldHash, "oldHash");
            this.newHash = Objects.requireNonNull(newHash, "newHash");
        }

        public String toString() {
            return "{old-hash: " + this.oldHash + ", new-hash: " + this.newHash + "}";
        }

        public static MinimalRefChange merge(MinimalRefChange first, MinimalRefChange second) {
            if (first == null) {
                return second;
            }
            if (second == null) {
                return first;
            }
            return new MinimalRefChange(first.oldHash, second.newHash);
        }

        public static MinimalRefChange valueOf(RefChange change) {
            if (change == null) {
                return null;
            }
            switch (change.getType()) {
                case ADD: {
                    throw new IllegalArgumentException("Adds should be ignored");
                }
                case DELETE: {
                    return new MinimalRefChange(change.getFromHash(), PullRequestRescopeChain.NULL_SHA);
                }
            }
            return new MinimalRefChange(change.getFromHash(), change.getToHash());
        }
    }

    public static class Builder {
        private final List<InternalRescopeRequest> candidates;
        private final SimpleMinimalPullRequest pullRequest;
        private final Date startDate;
        private final LinkedList<Segment> segments;
        private String curFromRefHash;
        private String curToRefHash;
        private Date targetDate;
        private String targetFromRefHash;
        private String targetToRefHash;

        public Builder(@Nonnull SimpleMinimalPullRequest pullRequest) {
            this.pullRequest = pullRequest;
            this.startDate = pullRequest.getRescopeDate();
            this.candidates = new ArrayList<InternalRescopeRequest>(2);
            this.segments = new LinkedList();
            this.curFromRefHash = pullRequest.getFromRef().getLatestCommit();
            this.curToRefHash = pullRequest.getToRef().getLatestCommit();
            this.targetDate = new Date();
        }

        @VisibleForTesting
        Builder(InternalPullRequest pullRequest) {
            this(new SimpleMinimalPullRequest(pullRequest));
        }

        @Nonnull
        public PullRequestRescopeChain build() {
            return new PullRequestRescopeChain(this);
        }

        @Nonnull
        public Builder request(InternalRescopeRequest request) {
            if (!this.isInScope(request)) {
                return this;
            }
            if (request.getChanges().isEmpty()) {
                this.candidates.add(request);
                return this;
            }
            this.maybeCreateSegment(request).ifPresent(newSegment -> {
                this.maybeInsertGapPrecedingSegment((AttributedSegment)newSegment);
                this.segments.add((Segment)newSegment);
                this.curFromRefHash = (String)MoreObjects.firstNonNull((Object)newSegment.getNewFromHash(), (Object)this.curFromRefHash);
                this.curToRefHash = (String)MoreObjects.firstNonNull((Object)newSegment.getNewToHash(), (Object)this.curToRefHash);
            });
            return this;
        }

        @Nonnull
        public Builder targetState(@Nonnull Date targetDate, @Nullable String targetFromHash, @Nullable String targetToHash) {
            this.targetDate = targetDate;
            this.targetFromRefHash = targetFromHash == null ? PullRequestRescopeChain.NULL_SHA : targetFromHash;
            this.targetToRefHash = targetToHash == null ? PullRequestRescopeChain.NULL_SHA : targetToHash;
            return this;
        }

        @Nonnull
        private List<SimplePullRequestRescope> buildRescopes() {
            Date lowerBound = this.startDate;
            String fromHash = this.pullRequest.getFromRef().getLatestCommit();
            String toHash = this.pullRequest.getToRef().getLatestCommit();
            ImmutableList.Builder result = ImmutableList.builder();
            ArrayList<InternalRescopeRequest> resolveCandidates = new ArrayList<InternalRescopeRequest>(this.candidates);
            ListIterator segmentIt = this.segments.listIterator();
            while (segmentIt.hasNext()) {
                Segment segment = (Segment)segmentIt.next();
                Date upperBound = this.getDate(segmentIt.nextIndex());
                AttributedSegment resolved = this.resolve(segment, lowerBound, upperBound, resolveCandidates);
                SimplePullRequestRescope rescope = this.createPullRequestRescope(resolved, fromHash, toHash);
                fromHash = rescope.getNewFromHash();
                toHash = rescope.getNewToHash();
                lowerBound = rescope.getDate();
                if (this.targetDate == null || !this.targetDate.before(rescope.getDate())) {
                    result.add((Object)rescope);
                }
                if (toHash != null && fromHash != null) continue;
                return result.build();
            }
            MinimalRefChange fromRefGap = null;
            MinimalRefChange toRefGap = null;
            if (this.targetFromRefHash != null && !ShaUtils.hashesMatch((String)this.curFromRefHash, (String)this.targetFromRefHash)) {
                fromRefGap = new MinimalRefChange(this.curFromRefHash, this.targetFromRefHash);
            }
            if (this.targetToRefHash != null && !ShaUtils.hashesMatch((String)this.curToRefHash, (String)this.targetToRefHash)) {
                toRefGap = new MinimalRefChange(this.curToRefHash, this.targetToRefHash);
            }
            if (fromRefGap != null || toRefGap != null) {
                GapSegment unresolved = new GapSegment(fromRefGap, toRefGap);
                AttributedSegment resolved = this.resolve(unresolved, lowerBound, this.targetDate, resolveCandidates);
                result.add((Object)this.createPullRequestRescope(resolved, this.curFromRefHash, this.curToRefHash));
            }
            return result.build();
        }

        private boolean isInScope(InternalRescopeRequest request) {
            InternalRepository repository = request.getRepository();
            Date date = request.getCreatedDate();
            return (repository.equals(this.pullRequest.getFromRef().getRepository()) || repository.equals(this.pullRequest.getToRef().getRepository())) && !this.startDate.after(date) && !this.targetDate.before(date);
        }

        private void maybeInsertGapPrecedingSegment(AttributedSegment segment) {
            MinimalRefChange fromRefGap = null;
            MinimalRefChange toRefGap = null;
            if (PullRequestRescopeChain.hasGap(this.curFromRefHash, segment.fromRefChange)) {
                fromRefGap = new MinimalRefChange(this.curFromRefHash, segment.getOldFromHash());
            }
            if (PullRequestRescopeChain.hasGap(this.curToRefHash, segment.toRefChange)) {
                toRefGap = new MinimalRefChange(this.curToRefHash, segment.getOldToHash());
            }
            if (fromRefGap != null || toRefGap != null) {
                GapSegment gap = new GapSegment(fromRefGap, toRefGap);
                ListIterator<Segment> it = this.segments.listIterator(this.segments.size());
                while (it.hasPrevious()) {
                    Segment s = it.previous();
                    if (s instanceof GapSegment) {
                        it.set(((GapSegment)s).merge(gap));
                        return;
                    }
                    if ((fromRefGap == null || s.fromRefChange == null) && (toRefGap == null || s.toRefChange == null)) continue;
                    break;
                }
                this.segments.add(gap);
            }
        }

        private Optional<AttributedSegment> maybeCreateSegment(InternalRescopeRequest request) {
            MinimalRefChange fromChange = null;
            MinimalRefChange toChange = null;
            boolean matchFrom = request.getRepository().equals((Object)this.pullRequest.getFromRef().getRepository());
            boolean matchTo = request.getRepository().equals((Object)this.pullRequest.getToRef().getRepository());
            for (RefChange change : request.getChanges()) {
                if (change.getType() == RefChangeType.ADD || StandardRefType.TAG.equals((Object)change.getRef().getType())) continue;
                if (matchFrom && fromChange == null && change.getRef().getId().equals(this.pullRequest.getFromRef().getId())) {
                    fromChange = MinimalRefChange.valueOf(change);
                    continue;
                }
                if (!matchTo || toChange != null || !change.getRef().getId().equals(this.pullRequest.getToRef().getId())) continue;
                toChange = MinimalRefChange.valueOf(change);
            }
            if (fromChange == null && toChange == null) {
                return Optional.empty();
            }
            return Optional.of(new AttributedSegment(request.getCreatedDate(), (ApplicationUser)request.getUser(), fromChange, toChange));
        }

        private SimplePullRequestRescope createPullRequestRescope(AttributedSegment resolved, @Nonnull String defaultFromHash, @Nonnull String defaultToHash) {
            String oldFromHash = Objects.requireNonNull(Builder.calculateHash(resolved.getOldFromHash(), defaultFromHash), "oldFromHash");
            String newFromHash = Builder.calculateHash(resolved.getNewFromHash(), defaultFromHash);
            String oldToHash = Objects.requireNonNull(Builder.calculateHash(resolved.getOldToHash(), defaultToHash), "oldToHash");
            String newToHash = Builder.calculateHash(resolved.getNewToHash(), defaultToHash);
            return new SimplePullRequestRescope(this.pullRequest, resolved.date, resolved.user, oldFromHash, oldToHash, newFromHash, newToHash);
        }

        private static String calculateHash(String resolvedHash, @Nonnull String defaultHash) {
            if (PullRequestRescopeChain.NULL_SHA.equals(resolvedHash)) {
                return null;
            }
            return (String)MoreObjects.firstNonNull((Object)resolvedHash, (Object)defaultHash);
        }

        private ApplicationUser getBestUser(Segment gap) {
            int fromWeight = gap.fromRefChange != null ? 5 : 1;
            int toWeight = gap.toRefChange != null ? 3 : 1;
            HashMap userScores = new HashMap();
            this.segments.stream().filter(s -> s instanceof AttributedSegment).map(s -> (AttributedSegment)s).forEach(rescope -> {
                int score = fromWeight * (rescope.fromRefChange == null ? 0 : 1) + toWeight * (rescope.toRefChange == null ? 0 : 1);
                userScores.compute(((AttributedSegment)rescope).user, (user, value) -> value == null ? score : value + score);
            });
            this.candidates.stream().forEach(req -> userScores.compute(req.getUser(), (user, value) -> value == null ? 1 : value + 1));
            return userScores.entrySet().stream().reduce((entry, best) -> best == null || (Integer)best.getValue() < (Integer)entry.getValue() ? entry : best).map(Map.Entry::getKey).orElse(this.pullRequest.getCreatedBy());
        }

        private Date getDate(int segmentIndex) {
            if (segmentIndex < this.segments.size()) {
                ListIterator<Segment> it = this.segments.listIterator(segmentIndex);
                while (it.hasNext()) {
                    Segment segment = it.next();
                    if (!(segment instanceof AttributedSegment)) continue;
                    return ((AttributedSegment)segment).date;
                }
            }
            return this.targetDate;
        }

        @Nonnull
        public SimpleMinimalPullRequest getPullRequest() {
            return this.pullRequest;
        }

        private AttributedSegment resolve(Segment segment, Date lowerBound, Date upperBound, List<InternalRescopeRequest> candidates) {
            if (segment instanceof AttributedSegment) {
                return (AttributedSegment)segment;
            }
            Iterator<InternalRescopeRequest> it = candidates.iterator();
            while (it.hasNext()) {
                InternalRescopeRequest request = it.next();
                Date date = request.getCreatedDate();
                if (date.before(lowerBound) || date.after(upperBound)) continue;
                it.remove();
                return new AttributedSegment(date, (ApplicationUser)request.getUser(), segment.fromRefChange, segment.toRefChange);
            }
            Date date = new Date(upperBound.getTime() / 2L + lowerBound.getTime() / 2L);
            ApplicationUser bestUser = this.getBestUser(segment);
            log.warn("{}: A gap was detected in the pull request history: {}. Attributing the scope change to user {} and setting the rescope date to {} based on known changes", new Object[]{PullRequestRescopeChain.describe((MinimalPullRequest)this.pullRequest), segment, bestUser != null ? bestUser.getName() : "unknown", date});
            return new AttributedSegment(date, bestUser, segment.fromRefChange, segment.toRefChange);
        }
    }
}

