/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DriftContext
implements Iterable<InternalPullRequestDiffCommentAnchor> {
    private final List<InternalPullRequestDiffCommentAnchor> anchors;
    private final PullRequestEffectiveDiff currentDiff;
    private final PullRequestEffectiveDiff previousDiff;
    private final String previousFromHash;
    private final String previousToHash;
    private final InternalPullRequest pullRequest;
    private final InternalRepository repository;
    private final List<InternalPullRequestDiffCommentAnchor> updated;

    public DriftContext(InternalRepository repository, InternalPullRequest pullRequest, String previousFromHash, String previousToHash, PullRequestEffectiveDiff currentDiff, PullRequestEffectiveDiff previousDiff, List<InternalPullRequestDiffCommentAnchor> anchors) {
        Preconditions.checkArgument((!((List)Preconditions.checkNotNull(anchors, (Object)"anchors")).isEmpty() ? 1 : 0) != 0, (Object)"At least one anchor to process is required");
        this.anchors = anchors;
        this.currentDiff = (PullRequestEffectiveDiff)Preconditions.checkNotNull((Object)currentDiff, (Object)"currentDiff");
        this.previousDiff = (PullRequestEffectiveDiff)Preconditions.checkNotNull((Object)previousDiff, (Object)"previousDiff");
        this.previousFromHash = previousFromHash;
        this.previousToHash = previousToHash;
        this.pullRequest = pullRequest;
        this.repository = (InternalRepository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
        this.updated = Lists.newArrayListWithCapacity((int)anchors.size());
    }

    public List<InternalPullRequestDiffCommentAnchor> done() {
        if (this.anchors.isEmpty()) {
            return Collections.unmodifiableList(this.updated);
        }
        throw new IllegalStateException(this.anchors.size() + " comments were not processed");
    }

    public void drift(InternalPullRequestDiffCommentAnchor anchor, int drift) {
        this.updated.add(((InternalPullRequestDiffCommentAnchor.Builder)this.updateHashes(anchor).line(anchor.getLine() + drift, anchor.getLineType(), anchor.getFileType())).build());
    }

    public PullRequestEffectiveDiff getCurrentDiff() {
        return this.currentDiff;
    }

    public PullRequestEffectiveDiff getPreviousDiff() {
        return this.previousDiff;
    }

    public String getPreviousFromHash() {
        return this.previousFromHash;
    }

    public String getPreviousToHash() {
        return this.previousToHash;
    }

    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    public InternalRepository getRepository() {
        return this.repository;
    }

    public boolean isEmpty() {
        return this.anchors.isEmpty();
    }

    @Override
    public Iterator<InternalPullRequestDiffCommentAnchor> iterator() {
        return this.anchors.iterator();
    }

    public void orphan(InternalPullRequestDiffCommentAnchor anchor) {
        this.updated.add(new InternalPullRequestDiffCommentAnchor.Builder(anchor).orphaned(true).build());
    }

    public void retain(InternalPullRequestDiffCommentAnchor anchor) {
        this.updated.add(this.updateHashes(anchor).build());
    }

    private InternalPullRequestDiffCommentAnchor.Builder updateHashes(InternalPullRequestDiffCommentAnchor anchor) {
        return (InternalPullRequestDiffCommentAnchor.Builder)((InternalPullRequestDiffCommentAnchor.Builder)new InternalPullRequestDiffCommentAnchor.Builder(anchor).fromHash(this.currentDiff.getSinceId())).toHash(this.currentDiff.getUntilId());
    }
}

