/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.core.OrderComparator;

public class CompositeCommentDriftStrategy
implements CommentDriftStrategy {
    private final List<CommentDriftStrategy> strategies;

    public CompositeCommentDriftStrategy(List<CommentDriftStrategy> strategies) {
        this.strategies = Lists.newArrayList(strategies);
        OrderComparator.sort(this.strategies);
    }

    @Override
    public void apply(@Nonnull DriftContext context) {
        Long pullRequestId = context.getPullRequest().getGlobalId();
        for (CommentDriftStrategy strategy : this.strategies) {
            try (Timer ignored = TimerUtils.start((String)("Drift: Strategy - " + strategy.getName() + " " + pullRequestId));){
                strategy.apply(context);
            }
            if (!context.isEmpty()) continue;
            break;
        }
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder("Composite (");
        boolean first = true;
        for (CommentDriftStrategy strategy : this.strategies) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(strategy.getName());
        }
        return builder.append(")").toString();
    }
}

