/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.bitbucket.content.AbstractDiffContentCallback;
import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextBatch;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class CommentContextDiffContentCallback
extends AbstractDiffContentCallback {
    private final Map<String, DiffContextBatch> batchesByPath;
    private DiffContextBatch batch;

    public CommentContextDiffContentCallback(@Nonnull Set<InternalPullRequestCommentActivity> activities, @Nonnull PropertyMap properties) {
        this.batchesByPath = CommentContextDiffContentCallback.mapBatches(activities, properties);
    }

    public void onDiffEnd(boolean truncated) {
        if (this.batch != null) {
            this.batch.endDiff();
            this.batch = null;
        }
    }

    public void onDiffStart(Path src, Path dst) {
        String path = dst == null ? src.toString() : dst.toString();
        this.batch = this.batchesByPath.get(path);
    }

    public void onHunkEnd(boolean truncated) {
        if (this.batch != null) {
            this.batch.endHunk();
        }
    }

    public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan) {
        if (this.batch != null) {
            this.batch.startHunk(srcLine, dstLine);
        }
    }

    public void onSegmentLine(@Nonnull String line, ConflictMarker marker, boolean truncated) {
        if (this.batch != null) {
            this.batch.processLine(line, marker, truncated);
        }
    }

    public void onSegmentStart(@Nonnull DiffSegmentType type) {
        if (this.batch != null) {
            this.batch.startSegment(type);
        }
    }

    @Nonnull
    private static Map<String, DiffContextBatch> mapBatches(Set<InternalPullRequestCommentActivity> activities, final PropertyMap properties) {
        HashMap activitiesByPath = Maps.newHashMap();
        for (InternalPullRequestCommentActivity activity : activities) {
            InternalPullRequestDiffCommentAnchor anchor = activity.getCommentAnchor();
            if (anchor == null || anchor.isFileComment() || StringUtils.isBlank((CharSequence)anchor.getFromHash())) continue;
            Set byPath = (Set)activitiesByPath.get(anchor.getPath());
            if (byPath == null) {
                byPath = Sets.newHashSet();
                activitiesByPath.put(anchor.getPath(), byPath);
            }
            byPath.add(activity);
        }
        if (activitiesByPath.isEmpty()) {
            throw new IllegalStateException("No line-anchored comments were found in the provided activities. Performing a diff to gather context is not necessary");
        }
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)activitiesByPath, (Function)new Function<Set<InternalPullRequestCommentActivity>, DiffContextBatch>(){

            public DiffContextBatch apply(Set<InternalPullRequestCommentActivity> activities) {
                return new DiffContextBatch(activities, properties);
            }
        }));
    }
}

