/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.bitbucket.comment.DiffCommentAnchor;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.pull.AbstractPullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.pull.PullRequestDiffCommentAnchor;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.DiffCommandParameters;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.PullRequestActivityEnricher;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.pull.comment.diff.CommentContextDiffContentCallback;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CommentPullRequestActivityEnricher
implements PullRequestActivityEnricher {
    private static final Predicate<PullRequestCommentActivity> LINE_COMMENTS = activity -> {
        PullRequestDiffCommentAnchor anchor = activity.getCommentAnchor();
        return anchor != null && anchor.isLineComment() && StringUtils.isNotBlank((CharSequence)anchor.getFromHash());
    };
    private static final Function<InternalPullRequestCommentActivity, InternalComment> TO_COMMENT = InternalPullRequestCommentActivity::getComment;
    private static final Logger log = LoggerFactory.getLogger(CommentPullRequestActivityEnricher.class);
    private final CommentPostProcessor postProcessor;
    private final ScmService scmService;
    @Value(value="${pullrequest.diff.context}")
    private int diffContext;
    @Value(value="${page.max.source.length}")
    private int maxLineLength;

    @Autowired
    public CommentPullRequestActivityEnricher(CommentPostProcessor postProcessor, ScmService scmService) {
        this.postProcessor = postProcessor;
        this.scmService = scmService;
    }

    @Override
    public void enrich(@Nonnull InternalPullRequest pullRequest, @Nonnull Iterable<InternalPullRequestActivity> activities) {
        List<InternalPullRequestCommentActivity> commentActivities = CommentPullRequestActivityEnricher.getCommentActivities(activities);
        if (commentActivities.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("{}: Of {} activities, none relate to comments", (Object)pullRequest.getGlobalId(), (Object)Iterables.size(activities));
            }
            return;
        }
        this.postProcessor.processAll((InternalCommentable)pullRequest, Chainable.chain(commentActivities).transform(TO_COMMENT).toSet());
        ImmutableList lineActivities = ImmutableList.copyOf((Collection)Collections2.filter(commentActivities, LINE_COMMENTS));
        if (lineActivities.isEmpty()) {
            log.trace("{}: Of {} comment activities, none relate to diff lines", (Object)pullRequest.getGlobalId(), (Object)commentActivities.size());
        } else {
            this.applyDiffs(pullRequest, (List<InternalPullRequestCommentActivity>)lineActivities);
        }
    }

    private void applyDiffs(InternalPullRequest pullRequest, List<InternalPullRequestCommentActivity> activities) {
        log.debug("{}: Sifting diffs for {} diff line comment(s)", (Object)pullRequest.getGlobalId(), (Object)activities.size());
        HashMap diffs = Maps.newHashMapWithExpectedSize((int)activities.size());
        for (InternalPullRequestCommentActivity activity : activities) {
            DiffHashes hashes = new DiffHashes((DiffCommentAnchor)activity.getCommentAnchor());
            Set byHashes = (Set)diffs.get(hashes);
            if (byHashes == null) {
                byHashes = Sets.newHashSet();
                diffs.put(hashes, byHashes);
            }
            byHashes.add(activity);
        }
        PullRequestEffectiveDiff effectiveDiff = (PullRequestEffectiveDiff)this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).effectiveDiff().call();
        log.debug("{}: Performing {} diff(s) to build context for {} comment(s)", new Object[]{pullRequest.getGlobalId(), diffs.size(), activities.size()});
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory((Repository)pullRequest.getScopeRepository());
        for (Map.Entry entry : diffs.entrySet()) {
            DiffHashes hashes = (DiffHashes)entry.getKey();
            Set set = (Set)entry.getValue();
            List<String> paths = CommentPullRequestActivityEnricher.getDiffPaths(set);
            boolean isCurrentDiff = CommentPullRequestActivityEnricher.isCurrentDiff(effectiveDiff, hashes);
            PropertyMap properties = new PropertyMap.Builder().property("current", (Object)isCurrentDiff).property("fromHash", (Object)hashes.from).property("toHash", (Object)hashes.to).build();
            DiffCommandParameters parameters = ((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(Integer.MAX_VALUE)).paths(paths)).sinceId(hashes.from).untilId(hashes.to).build();
            log.debug("{}: Performing diff from {} to {} for {} comment(s) in {} file(s)", new Object[]{pullRequest.getGlobalId(), hashes.from, hashes.to, set.size(), paths.size()});
            try {
                commandFactory.diff(parameters, (DiffContentCallback)new CommentContextDiffContentCallback(set, properties)).call();
            }
            catch (NoSuchCommitException e) {
                log.debug("{}: Context for {} comment(s) in {} file(s) could not be loaded due to a missing commit: {}", new Object[]{pullRequest.getGlobalId(), set.size(), paths.size(), e.getCommitId()});
            }
        }
    }

    private static List<InternalPullRequestCommentActivity> getCommentActivities(Iterable<InternalPullRequestActivity> activities) {
        WinnowingVisitor visitor = new WinnowingVisitor();
        for (PullRequestActivity pullRequestActivity : activities) {
            pullRequestActivity.accept((PullRequestActivityVisitor)visitor);
        }
        return visitor.getActivities();
    }

    private static List<String> getDiffPaths(Set<InternalPullRequestCommentActivity> activities) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (InternalPullRequestCommentActivity activity : activities) {
            InternalPullRequestDiffCommentAnchor anchor = activity.getCommentAnchor();
            if (anchor == null) continue;
            builder.add((Object)anchor.getPath());
            String srcPath = anchor.getSrcPath();
            if (!StringUtils.isNotBlank((CharSequence)srcPath)) continue;
            builder.add((Object)srcPath);
        }
        return builder.build();
    }

    private static boolean isCurrentDiff(PullRequestEffectiveDiff effectiveDiff, DiffHashes hashes) {
        return StringUtils.equals((CharSequence)hashes.from, (CharSequence)effectiveDiff.getSinceId()) && StringUtils.equals((CharSequence)hashes.to, (CharSequence)effectiveDiff.getUntilId());
    }

    private static class WinnowingVisitor
    extends AbstractPullRequestActivityVisitor {
        private final ImmutableList.Builder<InternalPullRequestCommentActivity> builder = ImmutableList.builder();

        private WinnowingVisitor() {
        }

        public List<InternalPullRequestCommentActivity> getActivities() {
            return this.builder.build();
        }

        public void visit(@Nonnull PullRequestCommentActivity activity) {
            this.builder.add((Object)((InternalPullRequestCommentActivity)activity));
        }
    }

    private static class DiffHashes {
        private final String from;
        private final String to;

        public DiffHashes(DiffCommentAnchor anchor) {
            this.from = (String)Preconditions.checkNotNull((Object)((DiffCommentAnchor)Preconditions.checkNotNull((Object)anchor, (Object)"anchor")).getFromHash(), (Object)"anchor.fromHash");
            this.to = (String)Preconditions.checkNotNull((Object)anchor.getToHash(), (Object)"anchor.toHash");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DiffHashes) {
                DiffHashes d = (DiffHashes)o;
                return Objects.equals(this.from, d.from) && Objects.equals(this.to, d.to);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }
    }
}

