/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.comment.AddDiffCommentRequest;
import com.atlassian.bitbucket.comment.AddFileCommentRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.DiffCommentAnchor;
import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.BatchingCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitEnricher;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.commit.SimpleMinimalCommit;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.event.pull.PullRequestActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergeActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReopenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopeActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.pull.DuplicatePullRequestException;
import com.atlassian.bitbucket.pull.EmptyPullRequestException;
import com.atlassian.bitbucket.pull.IllegalPullRequestSearchRequestException;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.InvalidPullRequestRoleException;
import com.atlassian.bitbucket.pull.InvalidPullRequestTargetException;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestActivityPage;
import com.atlassian.bitbucket.pull.PullRequestActivitySearchRequest;
import com.atlassian.bitbucket.pull.PullRequestChangesRequest;
import com.atlassian.bitbucket.pull.PullRequestDeclineRequest;
import com.atlassian.bitbucket.pull.PullRequestDiffRequest;
import com.atlassian.bitbucket.pull.PullRequestEntityType;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.pull.PullRequestMergeRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeVetoedException;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.pull.PullRequestOpenCanceledException;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestOutOfDateException;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.pull.PullRequestSupplier;
import com.atlassian.bitbucket.pull.PullRequestTaskSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestUpdateRequest;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.pull.PullRequestChangeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDiffCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestMergeCommandParameters;
import com.atlassian.bitbucket.task.Task;
import com.atlassian.bitbucket.task.TaskAnchorType;
import com.atlassian.bitbucket.task.TaskCount;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.experimental.pull.ExperimentalPullRequestService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.comment.CommentCountChangeCallback;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.content.DiffContentCallbackFilter;
import com.atlassian.stash.internal.pull.AnalyticsPullRequestMergedEvent;
import com.atlassian.stash.internal.pull.DefaultPullRequestSupplier;
import com.atlassian.stash.internal.pull.InternalMergeRequest;
import com.atlassian.stash.internal.pull.InternalMergeRequestCheckService;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestMergeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipantHelper;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestActivityEnricher;
import com.atlassian.stash.internal.pull.PullRequestActivitySearchCriteria;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.pull.PullRequestEnricher;
import com.atlassian.stash.internal.pull.PullRequestParticipantCriteria;
import com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction;
import com.atlassian.stash.internal.pull.PullRequestSearchCriteria;
import com.atlassian.stash.internal.pull.SimpleMergeRequest;
import com.atlassian.stash.internal.pull.comment.InternalPullRequestCommentHelper;
import com.atlassian.stash.internal.pull.rescope.DeclineOutcome;
import com.atlassian.stash.internal.pull.rescope.MergeOutcome;
import com.atlassian.stash.internal.pull.rescope.RescopeOutcomeVisitor;
import com.atlassian.stash.internal.pull.rescope.RescopeProcessor;
import com.atlassian.stash.internal.pull.rescope.SimplePullRequestRescope;
import com.atlassian.stash.internal.pull.rescope.UpdateOutcome;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.task.InternalTaskContext;
import com.atlassian.stash.internal.task.InternalTaskSearchRequest;
import com.atlassian.stash.internal.task.InternalTaskService;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(interfaces={ExperimentalPullRequestService.class, PullRequestService.class, PullRequestSupplier.class})
@Service(value="pullRequestService")
public class DefaultPullRequestService
extends DefaultPullRequestSupplier
implements InternalPullRequestService {
    public static final String DIFF_CONTEXT_LINES = "${pullrequest.diff.context}";
    private static final Logger log = LoggerFactory.getLogger(DefaultPullRequestService.class);
    private final PullRequestActivityDao activityDao;
    private final List<PullRequestActivityEnricher> activityEnrichers;
    private final AuthenticationContext authenticationContext;
    private final InternalPullRequestCommentHelper commentHelper;
    private final CommitEnricher commitEnricher;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final InternalMergeRequestCheckService mergeRequestCheckService;
    private final InternalPullRequestParticipantHelper participantHelper;
    private final PermissionService permissionService;
    private final PermissionPredicateFactory predicateFactory;
    private final PullRequestEnricher pullRequestEnricher;
    private final RefService refService;
    private final RescopeProcessor rescopeProcessor;
    private final ScmService scmService;
    private final SecurityService securityService;
    private final InternalTaskService taskService;
    private final UserService userService;
    private final Validator validator;
    private final InternalWatcherService watcherService;
    private final TransactionTemplate withNewTransaction;
    @Value(value="${pullrequest.diff.context}")
    private int diffContext;
    @Value(value="${page.max.pullrequest.activities}")
    private int maxActivities;
    @Value(value="${page.max.changes}")
    private int maxChanges;
    @Value(value="${page.max.commits}")
    private int maxCommits;
    @Value(value="${page.max.diff.lines}")
    private int maxDiffLines;
    @Value(value="${page.max.source.length}")
    private int maxLineLength;
    @Value(value="${page.max.pullrequests}")
    private int maxPullRequests;

    @Autowired
    public DefaultPullRequestService(PullRequestDao pullRequestDao, PullRequestActivityDao activityDao, List<PullRequestActivityEnricher> activityEnrichers, AuthenticationContext authenticationContext, InternalPullRequestCommentHelper commentHelper, CommitEnricher commitEnricher, EventPublisher eventPublisher, I18nService i18nService, InternalMergeRequestCheckService mergeRequestCheckService, InternalPullRequestParticipantHelper participantHelper, PermissionService permissionService, PermissionPredicateFactory predicateFactory, PullRequestEnricher pullRequestEnricher, RefService refService, RescopeProcessor rescopeProcessor, ScmService scmService, SecurityService securityService, InternalTaskService taskService, PlatformTransactionManager transactionManager, UserService userService, Validator validator, InternalWatcherService watcherService) {
        super(pullRequestDao);
        this.activityDao = activityDao;
        this.activityEnrichers = activityEnrichers;
        this.authenticationContext = authenticationContext;
        this.commentHelper = commentHelper;
        this.commitEnricher = commitEnricher;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.mergeRequestCheckService = mergeRequestCheckService;
        this.refService = refService;
        this.participantHelper = participantHelper;
        this.permissionService = permissionService;
        this.predicateFactory = predicateFactory;
        this.pullRequestEnricher = pullRequestEnricher;
        this.rescopeProcessor = rescopeProcessor;
        this.scmService = scmService;
        this.securityService = securityService;
        this.taskService = taskService;
        this.userService = userService;
        this.validator = validator;
        this.watcherService = watcherService;
        this.withNewTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Comment addComment(int repositoryId, long pullRequestId, @Nonnull String commentText) {
        return this.internalAddComment(this.getPullRequestOrFail(repositoryId, pullRequestId), commentText);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Comment addDiffComment(int repositoryId, long pullRequestId, @Nonnull AddDiffCommentRequest request) {
        Objects.requireNonNull(request, "request");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
        return this.commentHelper.createDiffComment((InternalCommentable)pullRequest, request);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Comment addFileComment(int repositoryId, long pullRequestId, @Nonnull AddFileCommentRequest request) {
        Objects.requireNonNull(request, "request");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
        return this.commentHelper.createFileComment((InternalCommentable)pullRequest, request);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Comment addReply(int repositoryId, long pullRequestId, long commentId, @Nonnull String commentText) {
        Objects.requireNonNull(commentText, "commentText");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
        return this.commentHelper.createReply((InternalCommentable)pullRequest, commentId, commentText);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequestParticipant addReviewer(int repositoryId, long pullRequestId, @Nonnull String username) {
        this.validateCanUpdateReviewer(repositoryId, username);
        return this.participantHelper.addReviewer(this.getPullRequestOrFail(repositoryId, pullRequestId), (ApplicationUser)InternalConverter.convertToInternalUser((ApplicationUser)this.getUserOrFail(username)));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequestParticipant approve(int repositoryId, long pullRequestId) {
        return this.setReviewerStatus(repositoryId, pullRequestId, PullRequestParticipantStatus.APPROVED);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_WRITE')")
    @Transactional
    public PullRequestParticipant assignRole(int repositoryId, long pullRequestId, @Nonnull String username, @Nonnull PullRequestRole role) {
        if (Objects.requireNonNull(role, "role") != PullRequestRole.REVIEWER) {
            throw new InvalidPullRequestRoleException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.role.assign.restriction", new Object[]{PullRequestRole.REVIEWER.name().toLowerCase(Locale.ROOT)}));
        }
        return this.participantHelper.addReviewer(this.getPullRequestOrFail(repositoryId, pullRequestId), this.getUserOrFail(username));
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public PullRequestMergeability canMerge(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.checkIsOpen(pullRequest);
        return this.mergeRequestCheckService.checkMergeability((InternalMergeRequest)new SimpleMergeRequest.Builder((PullRequest)pullRequest).build());
    }

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Unsecured(value="Internal interface method")
    public PullRequest closeMerged(long globalId, int version) {
        return this.internalCloseMerged(this.getPullRequestOrFail(globalId), version, new Date());
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public long countCommits(int repositoryId, long pullRequestId) {
        CommitsBetweenRequest request = this.buildCommitsBetweenRequest(repositoryId, pullRequestId);
        CountingCommitCallback countingCallback = new CountingCommitCallback();
        this.scmService.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).build(), (CommitCallback)countingCallback).call();
        return countingCallback.getCount();
    }

    @PreAuthorize(value="isAuthenticated()")
    public long count(@Nonnull PullRequestSearchRequest request) {
        try {
            return this.pullRequestDao.countMatching(this.toCriteria(request));
        }
        catch (IllegalArgumentException e) {
            return 0L;
        }
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public TaskCount countTasks(@Nonnull PullRequestTaskSearchRequest request) {
        return this.taskService.count(this.convertToTaskSearchRequest(request));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#fromRepository, 'REPO_READ') and hasRepositoryPermission(#toRepository, 'REPO_READ')")
    @Transactional
    public InternalPullRequest create(@Nonnull String title, String description, @Nonnull Set<String> reviewers, @Nonnull Repository fromRepository, @Nonnull String fromBranchId, @Nonnull Repository toRepository, @Nonnull String toBranchId) {
        this.checkSameHierarchies(fromRepository, toRepository);
        this.checkNotSameBranches(fromRepository, fromBranchId, toRepository, toBranchId);
        Ref fromRef = this.resolveBranchOrFail(fromRepository, fromBranchId);
        Ref toRef = this.resolveBranchOrFail(toRepository, toBranchId);
        InternalPullRequestRef fromPullRef = this.createPullRequestRef(fromRepository, fromRef);
        InternalPullRequestRef toPullRef = this.createPullRequestRef(toRepository, toRef);
        this.checkUniquePullRequest(fromPullRef, toPullRef);
        this.checkHasCommits((PullRequestRef)fromPullRef, (PullRequestRef)toPullRef);
        Date now = new Date();
        InternalPullRequest pullRequest = new InternalPullRequest.Builder().title(title).description(description).fromRef(fromPullRef).toRef(toPullRef).createdDate(now).rescopedDate(now).updatedDate(now).state(PullRequestState.OPEN).build();
        ValidationUtils.validate((Validator)this.validator, (Object)pullRequest, (Class[])new Class[0]);
        InternalApplicationUser author = this.getCurrentUser();
        Set<ApplicationUser> resolvedReviewers = this.participantHelper.resolveReviewers(toRepository, (Set)reviewers.stream().filter(reviewer -> !reviewer.equals(author.getName())).collect(MoreCollectors.toImmutableSet()));
        this.fireOpenRequested((PullRequest)pullRequest, resolvedReviewers);
        pullRequest = (InternalPullRequest)this.pullRequestDao.create((Object)pullRequest);
        this.participantHelper.createParticipants(pullRequest, (ApplicationUser)author, resolvedReviewers);
        this.logActivity(pullRequest, PullRequestAction.OPENED);
        this.eventPublisher.publish((Object)new PullRequestOpenedEvent((Object)this, (PullRequest)pullRequest));
        return pullRequest;
    }

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Unsecured(value="Internal interface method")
    public PullRequest decline(long globalPullRequestId, int version) {
        return this.internalDecline(this.getPullRequestOrFail(globalPullRequestId), version, new Date(), null);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.getRepositoryId(), 'REPO_READ')")
    @Transactional
    public PullRequest decline(@Nonnull PullRequestDeclineRequest request) {
        Objects.requireNonNull(request, "request");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        return this.internalDecline(pullRequest, request.getVersion(), null, request.getComment());
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public boolean deleteComment(int repositoryId, long pullRequestId, long commentId, int commentVersion) {
        return this.commentHelper.delete((InternalCommentable)this.getPullRequestOrFail(repositoryId, pullRequestId), commentId, commentVersion);
    }

    @Unsecured(value="Internal interface method")
    public void ensureUpToDate(@Nonnull PullRequest pullRequest) {
        this.scmService.getPullRequestCommandFactory(pullRequest).effectiveDiff().call();
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Iterable<DiffCommentAnchor> findCommentAnchors(int repositoryId, long pullRequestId, @Nonnull String path) {
        Preconditions.checkArgument((!Objects.requireNonNull(path, "path").trim().isEmpty() ? 1 : 0) != 0, (Object)"A file path to find anchors for is required.");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.maybeUpdate(pullRequest);
        return this.commentHelper.findDiffAnchors(pullRequest, path);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Page<PullRequestActivity> getActivities(int repositoryId, long pullRequestId, @Nonnull PageRequest pageRequest) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.maybeUpdate(pullRequest);
        Page page = this.activityDao.findByPullRequest(pullRequest.getGlobalId(), pageRequest.buildRestrictedPageRequest(this.maxActivities));
        this.enrichActivities(pullRequest, (Page<InternalPullRequestActivity>)page, false);
        return page;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public PullRequestActivityPage<PullRequestActivity> getActivitiesStartingAt(int repositoryId, long pullRequestId, @Nonnull PullRequestEntityType fromType, long fromId, @Nonnull PageRequest pageRequest) {
        InternalPullRequestActivity activity;
        Objects.requireNonNull(fromType, "fromType");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.maybeUpdate(pullRequest);
        switch (fromType) {
            case ACTIVITY: {
                activity = this.getActivityOrFail(pullRequest, fromId);
                break;
            }
            case COMMENT: {
                InternalComment comment = this.commentHelper.getById((InternalCommentable)pullRequest, fromId).getRoot();
                activity = this.activityDao.findByComment(pullRequest.getGlobalId(), comment.getId());
                if (activity != null) break;
                throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.activities.noneforcomment", new Object[]{fromId}));
            }
            default: {
                throw new IllegalArgumentException("Unexpected entity type " + fromType);
            }
        }
        PullRequestActivityPage page = this.activityDao.findPageStartingAt(pullRequest.getGlobalId(), activity.getId(), pageRequest.buildRestrictedPageRequest(this.maxActivities));
        this.enrichActivities(pullRequest, (Page<InternalPullRequestActivity>)page, false);
        return (PullRequestActivityPage)PageUtils.asPageOf(PullRequestActivity.class, (Page)page);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Set<PullRequestActivity> getActivitiesById(int repositoryId, long pullRequestId, Set<Long> activityIds) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.maybeUpdate(pullRequest);
        List activities = this.activityDao.getByIds(activityIds);
        if (activities.isEmpty()) {
            return ImmutableSet.of();
        }
        for (PullRequestActivity activity : activities) {
            this.checkActivityBelongsToPullRequest(activity, pullRequest);
        }
        this.enrichActivities(pullRequest, activities, false);
        return ImmutableSet.copyOf((Collection)activities);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Comment getComment(int repositoryId, long pullRequestId, long commentId) {
        return this.commentHelper.getById((InternalCommentable)this.getPullRequestOrFail(repositoryId, pullRequestId), commentId);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Page<Commit> getCommits(int repositoryId, long pullRequestId, @Nonnull PageRequest pageRequest) {
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxCommits);
        CommitsBetweenRequest request = this.buildCommitsBetweenRequest(repositoryId, pullRequestId);
        Page commits = (Page)this.scmService.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).build(), pageRequest).call();
        return this.commitEnricher.enrichPage(request.getRepository(), commits, null);
    }

    public Map<PullRequestState, Long> getCountsByState() {
        Map countAllByStatus = this.pullRequestDao.countAllByStatus();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PullRequestState[] pullRequestStateArray = PullRequestState.values();
        int n = pullRequestStateArray.length;
        for (int i = 0; i < n; ++i) {
            PullRequestState state;
            Long count = (Long)countAllByStatus.get(state = pullRequestStateArray[i]);
            builder.put((Object)state, (Object)(count == null ? 0L : count));
        }
        return builder.build();
    }

    @Nullable
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Long getRootCommentId(int repositoryId, long pullRequestId, long commentId) {
        InternalComment comment = this.commentHelper.getById((InternalCommentable)this.getPullRequestOrFail(repositoryId, pullRequestId), commentId);
        return comment.getRoot().getId();
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Page<PullRequestParticipant> getParticipants(int repositoryId, long pullRequestId, @Nonnull PageRequest pageRequest) {
        return PageUtils.asPageOf(PullRequestParticipant.class, this.participantHelper.getParticipants(this.getPullRequestOrFail(repositoryId, pullRequestId), pageRequest));
    }

    @Nullable
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public PullRequest getPullRequest(int repositoryId, long commentId) {
        InternalPullRequest pullRequest = this.pullRequestDao.findByComment(commentId);
        return pullRequest != null && repositoryId == pullRequest.getScopeRepository().getId() ? pullRequest : null;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_WRITE')")
    @Transactional
    public PullRequest merge(@Nonnull PullRequestMergeRequest request) {
        Objects.requireNonNull(request, "request");
        ApplicationUser author = this.authenticationContext.getCurrentUser();
        if (author == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.anonymous", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)author.getEmailAddress())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.author.email", new Object[]{author.getName()}));
        }
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId(), request.getVersion());
        if (pullRequest.isLocked()) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.merging", new Object[0]));
        }
        InternalPullRequestRef fromRef = pullRequest.getFromRef();
        InternalPullRequestRef toRef = pullRequest.getToRef();
        InternalRepository repository = toRef.getRepository();
        if (!Objects.equals(repository.getHierarchyId(), fromRef.getRepository().getHierarchyId())) {
            throw new UnsupportedOperationException(this.i18nService.getMessage("bitbucket.service.pullrequest.merge.unsupported", new Object[0]));
        }
        PullRequestMergeability mergeability = this.mergeRequestCheckService.checkMergeability((InternalMergeRequest)new SimpleMergeRequest.Builder((PullRequest)pullRequest, request).build());
        if (!mergeability.canMerge()) {
            throw new PullRequestMergeVetoedException(this.buildMergeabilityMessage(mergeability), mergeability.getVetoes(), mergeability.isConflicted());
        }
        Date now = new Date();
        String mergeHash = new MergePullRequestOperation(pullRequest, author, now, request.getMessage(), request.getContext()).perform();
        this.pullRequestDao.refresh((Object)pullRequest);
        this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
        this.logMergeActivity(pullRequest, now, mergeHash);
        this.eventPublisher.publish((Object)new AnalyticsPullRequestMergedEvent(this, (PullRequest)pullRequest, (MinimalCommit)(mergeHash == null ? null : new SimpleMinimalCommit.Builder(mergeHash).build()), request.getMessage(), request.getContext()));
        if (mergeHash != null) {
            pullRequest.setProperties(new PropertyMap.Builder().property("mergeCommit", (Object)ImmutableMap.of((Object)"displayId", (Object)mergeHash.substring(0, 11), (Object)"id", (Object)mergeHash)).build());
        }
        return pullRequest;
    }

    @EventListener
    public void onRepositoryDeleteRequested(RepositoryDeletionRequestedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Repository repository = event.getRepository();
        try {
            this.cleanup(repository.getId());
        }
        catch (RuntimeException e) {
            log.error("{}: Pull requests could not be cleaned up on repository deletion", (Object)repository, (Object)e);
            event.cancel(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.cleanupfailed", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public void removeReviewer(int repositoryId, long pullRequestId, @Nonnull String username) {
        this.validateCanUpdateReviewer(repositoryId, username);
        this.participantHelper.removeReviewer(this.getPullRequestOrFail(repositoryId, pullRequestId), this.getUserOrFail(username));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequest reopen(int repositoryId, long pullRequestId, int version) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        if (pullRequest.getState() == PullRequestState.OPEN) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.reopen.opened", new Object[0]));
        }
        if (pullRequest.getState() == PullRequestState.MERGED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.reopen.merged", new Object[0]));
        }
        this.checkPullRequestVersion(version, pullRequest);
        this.checkUniquePullRequest(pullRequest.getFromRef(), pullRequest.getToRef());
        Ref resolvedFromRef = this.checkRefExistsForReopen(pullRequest.getFromRef());
        Ref resolvedToRef = this.checkRefExistsForReopen(pullRequest.getToRef());
        InternalPullRequestRef originalFromRef = pullRequest.getFromRef();
        String originalFromHash = originalFromRef.getLatestCommit();
        InternalPullRequestRef originalToRef = pullRequest.getToRef();
        String originalToHash = originalToRef.getLatestCommit();
        pullRequest = this.rescopeOnReopen(pullRequest, resolvedFromRef, resolvedToRef);
        Date now = new Date();
        pullRequest = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pullRequest).state(PullRequestState.OPEN).updatedDate(now).build());
        this.logActivity(pullRequest, PullRequestAction.REOPENED, now);
        this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
        this.eventPublisher.publish((Object)new PullRequestReopenedEvent((Object)this, (PullRequest)pullRequest, originalFromHash, originalToHash));
        return pullRequest;
    }

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Unsecured(value="Only called by internal code")
    public PullRequest rescope(long globalId, int version, @Nonnull List<SimplePullRequestRescope> rescopes) {
        InternalPullRequest current = this.getPullRequestOrFail(globalId, version);
        if (rescopes.isEmpty()) {
            return current;
        }
        if (current.isLocked()) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.merging", new Object[0]));
        }
        log.debug("PullRequest {} rescoping {}", (Object)current, rescopes);
        String oldFromHash = current.getFromRef().getLatestCommit();
        String oldToHash = current.getToRef().getLatestCommit();
        for (SimplePullRequestRescope rescope : rescopes) {
            InternalPullRequest pullRequest = current;
            current = (InternalPullRequest)this.securityService.impersonating(rescope.getUser(), "rescoping").call(() -> this.internalRescope(pullRequest, version, rescope));
        }
        if (current.isOpen()) {
            current = (InternalPullRequest)this.pullRequestDao.update((Object)current);
        }
        if (!Objects.equals(oldFromHash, current.getFromRef().getLatestCommit()) || !Objects.equals(oldToHash, current.getToRef().getLatestCommit())) {
            this.commentHelper.updateComments(current, oldFromHash, oldToHash);
        }
        return current;
    }

    @Nonnull
    @Secured(value="Secured internally by a predicate")
    public Page<PullRequest> search(@Nonnull PullRequestSearchRequest request, @Nonnull PageRequest pageRequest) {
        try {
            if (request.getOrder() == PullRequestOrder.PARTICIPANT_STATUS && request.getParticipants().size() != 1) {
                throw new IllegalPullRequestSearchRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.search.participants.order", new Object[]{PullRequestOrder.PARTICIPANT_STATUS}));
            }
            return this.search(this.toCriteria(request), pageRequest, request.isWithProperties());
        }
        catch (IllegalArgumentException e) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public Page<PullRequestActivity> searchActivities(@Nonnull PullRequestActivitySearchRequest request, @Nonnull PageRequest pageRequest) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        Page page = this.activityDao.search(new PullRequestActivitySearchCriteria.Builder(pullRequest, request).build(), pageRequest.buildRestrictedPageRequest(this.maxActivities));
        this.enrichActivities(pullRequest, (Page<InternalPullRequestActivity>)page, request.isWithProperties());
        return PageUtils.asPageOf(PullRequestActivity.class, (Page)page);
    }

    @Nonnull
    @Secured(value="Permission checks done internally")
    public Page<ApplicationUser> searchUsers(@Nonnull PullRequestParticipantSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        return this.participantHelper.searchUsers(searchRequest, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public Page<Task> searchTasks(@Nonnull PullRequestTaskSearchRequest request, @Nonnull PageRequest pageRequest) {
        return this.taskService.search(this.convertToTaskSearchRequest(request), pageRequest, true);
    }

    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public void streamChanges(@Nonnull PullRequestChangesRequest request, @Nonnull ChangeCallback callback) {
        Map countsByLocation;
        Objects.requireNonNull(callback, "callback");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        this.maybeUpdate(pullRequest);
        if (request.isWithComments() && !(countsByLocation = this.commentHelper.countsByLocation((InternalCommentable)pullRequest)).isEmpty()) {
            callback = new CommentCountChangeCallback(callback, countsByLocation);
        }
        this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).changes(((PullRequestChangeCommandParameters.Builder)new PullRequestChangeCommandParameters.Builder().maxChanges(this.maxChanges)).build(), callback).call();
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public void streamCommits(int repositoryId, long pullRequestId, @Nonnull CommitCallback callback) {
        Objects.requireNonNull(callback, "callback");
        final InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).commits((CommitCallback)new BatchingCommitCallback(callback, 25){

            protected boolean onCommits(@Nonnull Iterable<Commit> commits) throws IOException {
                commits = DefaultPullRequestService.this.commitEnricher.enrichAll((Repository)pullRequest.getScopeRepository(), commits, Collections.emptySet());
                return super.onCommits(commits);
            }
        }).call();
    }

    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public void streamDiff(@Nonnull PullRequestDiffRequest request, @Nonnull DiffContentCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        this.maybeUpdate(pullRequest);
        if (request.isWithComments()) {
            try {
                callback.offerAnchors(this.commentHelper.findDiffAnchors(pullRequest, request.getPath()));
            }
            catch (IOException e) {
                log.error("Error while callback.offerAnchors", (Throwable)e);
            }
        }
        this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).diff(((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)new PullRequestDiffCommandParameters.Builder().contextLines(request.hasContextLines() ? request.getContextLines() : this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(this.maxDiffLines)).paths(request.getPath(), new String[]{request.getSrcPath()})).whitespace(request.getWhitespace())).build(), DiffContentCallbackFilter.filter((DiffContentCallback)callback, (DiffContentFilter)request.getFilter())).call();
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_WRITE')")
    @Transactional
    public void unassignRole(int repositoryId, long pullRequestId, @Nonnull String username) {
        this.participantHelper.removeReviewer(this.getPullRequestOrFail(repositoryId, pullRequestId), this.getUserOrFail(username));
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional
    public boolean unwatch(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        return this.watcherService.removeCurrentUserAsWatcher((InternalWatchable)pullRequest);
    }

    @Nonnull
    @Secured(value="Permissions checks done internally")
    @Transactional
    public PullRequest update(@Nonnull PullRequestUpdateRequest request) {
        boolean changingToRef;
        Objects.requireNonNull(request, "request");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId(), request.getVersion());
        if (!this.currentUserCanEdit(pullRequest)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.update.permissions.insufficient", new Object[0]));
        }
        InternalPullRequestRef toPullRef = pullRequest.getToRef();
        boolean bl = changingToRef = request.getToBranchId() != null && !request.getToBranchId().equals(pullRequest.getToRef().getId());
        if (changingToRef) {
            InternalPullRequestRef fromPullRef = pullRequest.getFromRef();
            InternalRepository toRepository = pullRequest.getToRef().getRepository();
            this.checkNotSameBranches((Repository)fromPullRef.getRepository(), fromPullRef.getId(), (Repository)toRepository, request.getToBranchId());
            toPullRef = this.createPullRequestRef((Repository)toRepository, this.resolveBranchOrFail((Repository)toRepository, request.getToBranchId()));
            this.checkUniquePullRequest(fromPullRef, toPullRef);
            this.checkHasCommits((PullRequestRef)fromPullRef, (PullRequestRef)toPullRef);
        }
        String previousDescription = pullRequest.getDescription();
        String previousTitle = pullRequest.getTitle();
        InternalPullRequestRef previousToBranch = new InternalPullRequestRef.Builder(pullRequest.getToRef()).build();
        Date now = new Date();
        pullRequest = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pullRequest).description(this.trimRightToNull(request.getDescription())).title(request.getTitle()).toRef(toPullRef).updatedDate(now).build());
        this.logActivity(pullRequest, PullRequestAction.UPDATED, now);
        this.eventPublisher.publish((Object)new PullRequestUpdatedEvent((Object)this, (PullRequest)pullRequest, previousTitle, previousDescription, (Ref)(changingToRef ? previousToBranch : null)));
        this.participantHelper.setReviewers(pullRequest, request.getReviewers());
        if (changingToRef) {
            String previousFromHash = pullRequest.getFromRef().getLatestCommit();
            String previousToHash = previousToBranch.getLatestCommit();
            this.logRescopeActivity(pullRequest, now, previousFromHash, previousToHash);
            this.commentHelper.updateComments(pullRequest, previousFromHash, previousToHash);
            this.eventPublisher.publish((Object)new PullRequestRescopedEvent((Object)this, (PullRequest)pullRequest, previousFromHash, previousToHash));
        }
        return pullRequest;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Comment updateComment(int repositoryId, long pullRequestId, long commentId, int commentVersion, @Nonnull String commentText) {
        Objects.requireNonNull(commentText, "commentText");
        return this.commentHelper.update((InternalCommentable)this.getPullRequestOrFail(repositoryId, pullRequestId), commentId, commentVersion, commentText);
    }

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Unsecured(value="Internal interface method")
    public PullRequest updateScope(long globalId, int version, @Nonnull String newFromHash, @Nonnull String newToHash) {
        boolean toChanged;
        InternalPullRequest current = this.getPullRequestOrFail(globalId, version);
        InternalPullRequestRef currentFromRef = current.getFromRef();
        InternalPullRequestRef currentToRef = current.getToRef();
        String previousFromHash = currentFromRef.getLatestCommit();
        String previousToHash = currentToRef.getLatestCommit();
        boolean fromChanged = !Objects.equals(previousFromHash, newFromHash);
        boolean bl = toChanged = !Objects.equals(previousToHash, newToHash);
        if (!fromChanged && !toChanged) {
            return current;
        }
        Date now = new Date();
        InternalPullRequest.Builder builder = new InternalPullRequest.Builder(current).fromRef(new InternalPullRequestRef.Builder(currentFromRef).hash(newFromHash).build()).toRef(new InternalPullRequestRef.Builder(currentToRef).hash(newToHash).build());
        if (fromChanged) {
            this.participantHelper.makeCurrentUserParticipantAndWatcher(current);
            builder.updatedDate(now);
        }
        builder.rescopedDate(now);
        InternalPullRequest updated = (InternalPullRequest)this.pullRequestDao.update((Object)builder.build());
        this.logRescopeActivity(updated, now, previousFromHash, previousToHash);
        this.commentHelper.updateComments(updated, previousFromHash, previousToHash);
        this.eventPublisher.publish((Object)new PullRequestRescopedEvent((Object)this, (PullRequest)updated, previousFromHash, previousToHash));
        return updated;
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequestParticipant setReviewerStatus(int repositoryId, long pullRequestId, @Nonnull PullRequestParticipantStatus status) {
        return this.participantHelper.setStatus(this.getPullRequestOrFail(repositoryId, pullRequestId), status);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Watcher watch(int repositoryId, long pullRequestId) {
        return this.watcherService.addCurrentUserAsWatcher((InternalWatchable)this.getPullRequestOrFail(repositoryId, pullRequestId));
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequestParticipant withdrawApproval(int repositoryId, long pullRequestId) {
        return this.participantHelper.setStatus(this.getPullRequestOrFail(repositoryId, pullRequestId), PullRequestParticipantStatus.UNAPPROVED);
    }

    private CommitsBetweenRequest buildCommitsBetweenRequest(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        return new CommitsBetweenRequest.Builder((PullRequest)pullRequest).build();
    }

    private KeyedMessage buildMergeabilityMessage(PullRequestMergeability mergeability) {
        Preconditions.checkArgument((!mergeability.canMerge() && (mergeability.isConflicted() || !mergeability.getVetoes().isEmpty()) ? 1 : 0) != 0);
        if (mergeability.isConflicted()) {
            if (mergeability.getVetoes().isEmpty()) {
                return this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.conflicted", new Object[0]);
            }
            return this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.vetoedandconflicted", new Object[0]);
        }
        return this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.vetoed", new Object[0]);
    }

    private void checkHasCommits(PullRequestRef fromRef, PullRequestRef toRef) {
        Repository fromRepository = fromRef.getRepository();
        Repository toRepository = toRef.getRepository();
        if (this.isMerged(fromRepository, fromRef.getLatestCommit(), toRepository, toRef.getLatestCommit())) {
            KeyedMessage message = fromRepository.getId() == toRepository.getId() ? this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.empty.samerepository", new Object[]{toRef.getDisplayId(), fromRef.getDisplayId(), toRepository.getSlug()}) : (fromRepository.getProject().getId() == toRepository.getProject().getId() ? this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.empty.sameproject", new Object[]{toRef.getDisplayId(), toRepository.getSlug(), fromRef.getDisplayId(), fromRepository.getSlug()}) : this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.empty", new Object[]{toRef.getDisplayId(), toRepository.getProject().getName(), toRepository.getSlug(), fromRef.getDisplayId(), fromRepository.getProject().getName(), fromRepository.getSlug()}));
            throw new EmptyPullRequestException(message, fromRef, toRef);
        }
    }

    private void checkIsOpen(InternalPullRequest pullRequest) {
        PullRequestState state = pullRequest.getState();
        if (state == PullRequestState.DECLINED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.declined", new Object[0]));
        }
        if (state == PullRequestState.MERGED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.merge.merged", new Object[0]));
        }
    }

    private void checkNotSameBranches(Repository fromRepository, String fromBranch, Repository toRepository, String toBranch) {
        if (fromRepository.getId() == toRepository.getId() && Objects.equals(fromBranch, toBranch)) {
            throw new InvalidPullRequestTargetException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.samebranch", new Object[0]));
        }
    }

    private void checkPullRequestVersion(int version, InternalPullRequest pullRequest) {
        if (pullRequest.getVersion() != version) {
            throw new PullRequestOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.outofdate", new Object[0]), (PullRequest)pullRequest, version);
        }
    }

    private Ref checkRefExistsForReopen(InternalPullRequestRef ref) {
        Ref resolvedRef = this.refService.resolveRef((Repository)ref.getRepository(), ref.getId());
        if (resolvedRef == null) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.refdeleted", new Object[]{ref.getDisplayId()}));
        }
        return resolvedRef;
    }

    private void checkSameHierarchies(Repository fromRepository, Repository toRepository) {
        if (!Objects.equals(fromRepository.getHierarchyId(), toRepository.getHierarchyId())) {
            throw new InvalidPullRequestTargetException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.notsamehierarchy", new Object[0]));
        }
    }

    private void checkUniquePullRequest(InternalPullRequestRef fromRef, InternalPullRequestRef toRef) {
        InternalPullRequest pullRequest = this.pullRequestDao.findByRefs(fromRef, toRef);
        if (pullRequest != null) {
            throw new DuplicatePullRequestException((PullRequest)pullRequest, this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.duplicate", new Object[0]));
        }
    }

    private void cleanup(int repositoryId) {
        int count = this.pullRequestDao.deleteByToRepository(repositoryId);
        log.debug("Deleted {} pull request(s) TO repository {}", (Object)count, (Object)repositoryId);
        PagedIterable unmerged = new PagedIterable(request -> this.pullRequestDao.findUnmergedByFromRepository(repositoryId, request), PageUtils.newRequest((int)0, (int)50));
        for (InternalPullRequest pullRequest : unmerged) {
            this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).effectiveDiff().call();
            log.debug("Resolved up-to-date diff for {}/{}", (Object)pullRequest.getScopeRepository().getId(), (Object)pullRequest.getScopedId());
        }
        count = this.pullRequestDao.declineByFromRepository(repositoryId);
        log.debug("Declined {} open pull request(s) FROM repository {}", (Object)count, (Object)repositoryId);
        count = this.pullRequestDao.overwriteFromRepository(repositoryId);
        log.debug("Updated {} pull request(s) FROM repository {} to be intra-repository", (Object)count, (Object)repositoryId);
    }

    private InternalTaskSearchRequest convertToTaskSearchRequest(PullRequestTaskSearchRequest request) {
        InternalPullRequest pullRequest = request.hasPullRequest() ? InternalConverter.convertToInternalPullRequest((PullRequest)request.getPullRequest()) : this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        return new InternalTaskSearchRequest.Builder((InternalTaskContext)pullRequest).anchors((Iterable)request.getAnchorIds(), TaskAnchorType.COMMENT).build();
    }

    private InternalPullRequestRef createPullRequestRef(Repository fromRepository, Ref fromRef) {
        return (InternalPullRequestRef)ValidationUtils.validate((Validator)this.validator, (Object)new InternalPullRequestRef.Builder().repository(InternalConverter.convertToInternalRepository((Repository)fromRepository)).ref(fromRef).build(), (Class[])new Class[0]);
    }

    private boolean currentUserCanEdit(InternalPullRequest pullRequest) {
        InternalRepository repository = pullRequest.getScopeRepository();
        return this.isCurrentUser(pullRequest.getAuthor().getUser()) && this.permissionService.hasRepositoryPermission((Repository)repository, Permission.REPO_READ) || this.permissionService.hasRepositoryPermission((Repository)repository, Permission.REPO_WRITE);
    }

    private void enrichActivities(InternalPullRequest pullRequest, Page<InternalPullRequestActivity> page, boolean enrichPullRequest) {
        if (page.getSize() > 0) {
            this.enrichActivities(pullRequest, page.getValues(), enrichPullRequest);
        }
    }

    private void enrichActivities(InternalPullRequest pullRequest, Iterable<InternalPullRequestActivity> activities, boolean enrichPullRequest) {
        for (PullRequestActivityEnricher enricher : this.activityEnrichers) {
            enricher.enrich(pullRequest, activities);
        }
        if (enrichPullRequest) {
            Set pullRequests = Chainable.chain(activities).transform(InternalPullRequestActivity::getPullRequest).toSet();
            this.pullRequestEnricher.enrich(pullRequests);
        }
    }

    private void fireOpenRequested(PullRequest pullRequest, Set<ApplicationUser> reviewers) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new PullRequestOpenRequestedEvent((Object)this, pullRequest, reviewers, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.creationcanceled", new Object[0]);
            throw new PullRequestOpenCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private InternalApplicationUser getCurrentUser() {
        return InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser());
    }

    private InternalPullRequestActivity getActivityOrFail(InternalPullRequest pullRequest, long activityId) {
        InternalPullRequestActivity activity = (InternalPullRequestActivity)this.activityDao.getById((Object)activityId);
        if (activity == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.activity.nosuchactivity", new Object[]{activityId}));
        }
        this.checkActivityBelongsToPullRequest((PullRequestActivity)activity, pullRequest);
        return activity;
    }

    private void checkActivityBelongsToPullRequest(PullRequestActivity activity, InternalPullRequest pullRequest) {
        if (!activity.getPullRequest().equals(pullRequest)) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.activity.nosuchactivityforrequest", new Object[]{activity.getId()}));
        }
    }

    private InternalPullRequest getPullRequestOrFail(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.pullRequestDao.findByRepositoryScopedId(repositoryId, pullRequestId);
        if (pullRequest == null) {
            throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.repository.nosuchrequest", new Object[]{pullRequestId, repositoryId}));
        }
        return pullRequest;
    }

    private InternalPullRequest getPullRequestOrFail(int repositoryId, long pullRequestId, int version) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.checkPullRequestVersion(version, pullRequest);
        return pullRequest;
    }

    private InternalPullRequest getPullRequestOrFail(long globalPullRequestId) {
        InternalPullRequest pullRequest = (InternalPullRequest)this.pullRequestDao.getById((Object)globalPullRequestId);
        if (pullRequest == null) {
            throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.global.nosuchrequest", new Object[]{globalPullRequestId}));
        }
        return pullRequest;
    }

    private InternalPullRequest getPullRequestOrFail(long globalPullRequestId, int version) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(globalPullRequestId);
        this.checkPullRequestVersion(version, pullRequest);
        return pullRequest;
    }

    private ApplicationUser getUserOrFail(String username) {
        ApplicationUser user = this.userService.getUserByName(username);
        if (user == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.nosuchuser", new Object[]{username}), username);
        }
        return user;
    }

    private Comment internalAddComment(InternalPullRequest pullRequest, String commentText) {
        Objects.requireNonNull(commentText, "commentText");
        this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
        return this.commentHelper.create((InternalCommentable)pullRequest, commentText);
    }

    private InternalPullRequest internalCloseMerged(InternalPullRequest pullRequest, int version, Date date) {
        this.checkPullRequestVersion(version, pullRequest);
        InternalPullRequest updated = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pullRequest).state(PullRequestState.MERGED).build());
        this.logMergeActivity(updated, date, null);
        this.eventPublisher.publish((Object)new PullRequestMergedEvent((Object)this, (PullRequest)updated));
        return updated;
    }

    private InternalPullRequest internalDecline(InternalPullRequest pullRequest, int version, Date date, String commentText) {
        if (pullRequest.getState() == PullRequestState.DECLINED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.decline.declined", new Object[0]));
        }
        if (pullRequest.getState() == PullRequestState.MERGED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.decline.merged", new Object[0]));
        }
        if (pullRequest.isLocked()) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.decline.merging", new Object[0]));
        }
        this.checkPullRequestVersion(version, pullRequest);
        if (commentText != null) {
            this.internalAddComment(pullRequest, commentText);
        }
        Date declineDate = date == null ? new Date() : date;
        pullRequest = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pullRequest).state(PullRequestState.DECLINED).updatedDate(declineDate).build());
        this.logActivity(pullRequest, PullRequestAction.DECLINED, declineDate);
        this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
        this.eventPublisher.publish((Object)new PullRequestDeclinedEvent((Object)this, (PullRequest)pullRequest));
        return pullRequest;
    }

    private InternalPullRequest internalRescope(final InternalPullRequest pullRequest, final int version, final SimplePullRequestRescope rescope) {
        if (rescope.getOutcome() == null) {
            return this.internalUpdateScope(pullRequest, rescope, null, null);
        }
        return (InternalPullRequest)rescope.getOutcome().accept((RescopeOutcomeVisitor)new RescopeOutcomeVisitor<InternalPullRequest>(){

            public InternalPullRequest visit(@Nonnull DeclineOutcome declineOutcome) {
                return DefaultPullRequestService.this.internalDecline(pullRequest, version, rescope.getDate(), null);
            }

            public InternalPullRequest visit(@Nonnull MergeOutcome mergeOutcome) {
                return DefaultPullRequestService.this.internalCloseMerged(pullRequest, version, rescope.getDate());
            }

            public InternalPullRequest visit(@Nonnull UpdateOutcome updateOutcome) {
                return DefaultPullRequestService.this.internalUpdateScope(pullRequest, rescope, updateOutcome.getAddedCommits(), updateOutcome.getRemovedCommits());
            }
        });
    }

    private InternalPullRequest internalUpdateScope(InternalPullRequest pullRequest, SimplePullRequestRescope rescope, RescopeDetails addedCommits, RescopeDetails removedCommits) {
        this.logRescopeActivity(pullRequest, rescope, addedCommits, removedCommits);
        InternalPullRequest.Builder builder = new InternalPullRequest.Builder(pullRequest).fromRef(new InternalPullRequestRef.Builder(pullRequest.getFromRef()).hash(rescope.getNewFromHash()).build()).toRef(new InternalPullRequestRef.Builder(pullRequest.getToRef()).hash(rescope.getNewToHash()).build()).rescopedDate(rescope.getDate());
        if (!ShaUtils.hashesMatch((String)rescope.getOldFromHash(), (String)rescope.getNewFromHash())) {
            this.participantHelper.makeCurrentUserParticipantAndWatcher(pullRequest);
            builder.updatedDate(rescope.getDate());
        }
        InternalPullRequest updated = builder.build();
        this.eventPublisher.publish((Object)new PullRequestRescopedEvent((Object)this, (PullRequest)updated, rescope.getOldFromHash(), rescope.getOldToHash(), addedCommits, removedCommits));
        return updated;
    }

    private boolean isCurrentUser(ApplicationUser user) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        return Objects.equals(user.getName(), currentUser == null ? null : currentUser.getName());
    }

    private boolean isMerged(Repository fromRepository, String fromHash, Repository toRepository, String toHash) {
        IsEmptyCommitCallback callback = new IsEmptyCommitCallback();
        this.scmService.getCommandFactory(toRepository).commits(new CommitsCommandParameters.Builder().include(fromHash, new String[0]).exclude(toHash, new String[0]).secondaryRepository(fromRepository).build(), (CommitCallback)callback).call();
        return callback.isEmpty();
    }

    private void logActivity(InternalPullRequest pullRequest, PullRequestAction action) {
        this.logActivity(pullRequest, action, new Date());
    }

    private void logActivity(InternalPullRequest pullRequest, PullRequestAction action, Date when) {
        InternalPullRequestActivity activity = ((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)new InternalPullRequestActivity.Builder(pullRequest).action(action)).createdDate(when)).user(this.getCurrentUser())).build();
        this.activityDao.create((Object)activity);
        this.eventPublisher.publish((Object)new PullRequestActivityEvent((Object)this, (PullRequestActivity)activity));
    }

    private void logMergeActivity(InternalPullRequest pullRequest, Date when, String hash) {
        InternalPullRequestMergeActivity activity = ((InternalPullRequestMergeActivity.Builder)((InternalPullRequestMergeActivity.Builder)new InternalPullRequestMergeActivity.Builder(pullRequest).createdDate(when)).hash(hash).user(this.getCurrentUser())).build();
        this.activityDao.create((Object)activity);
        this.eventPublisher.publish((Object)new PullRequestMergeActivityEvent((Object)this, (PullRequestMergeActivity)activity));
    }

    private void logRescopeActivity(InternalPullRequest pullRequest, Date when, String previousFromHash, String previousToHash) {
        InternalPullRequestRescopeActivity activity = ((InternalPullRequestRescopeActivity.Builder)((InternalPullRequestRescopeActivity.Builder)new InternalPullRequestRescopeActivity.Builder(pullRequest).createdDate(when)).fromHash(pullRequest.getFromRef().getLatestCommit()).previousFromHash(previousFromHash).previousToHash(previousToHash).toHash(pullRequest.getToRef().getLatestCommit()).user(this.getCurrentUser())).build();
        this.activityDao.create((Object)activity);
        this.eventPublisher.publish((Object)new PullRequestRescopeActivityEvent((Object)this, (PullRequestRescopeActivity)activity));
        this.rescopeProcessor.queue(activity);
    }

    private void logRescopeActivity(InternalPullRequest pullRequest, SimplePullRequestRescope rescope, RescopeDetails addedCommits, RescopeDetails removedCommits) {
        if (addedCommits != null && removedCommits != null && addedCommits.getTotal() == 0 && removedCommits.getTotal() == 0) {
            return;
        }
        InternalPullRequestRescopeActivity.Builder builder = (InternalPullRequestRescopeActivity.Builder)((InternalPullRequestRescopeActivity.Builder)new InternalPullRequestRescopeActivity.Builder(pullRequest).createdDate(rescope.getDate())).fromHash(rescope.getNewFromHash()).previousFromHash(rescope.getOldFromHash()).previousToHash(rescope.getOldToHash()).toHash(rescope.getNewToHash()).user(InternalConverter.convertToInternalUser((ApplicationUser)rescope.getUser()));
        if (addedCommits != null) {
            builder.totalAdded(addedCommits.getTotal());
            addedCommits.getCommits().forEach(commit -> builder.commit(new InternalPullRequestRescopeCommit.Builder().commitId(commit.getId()).action(PullRequestRescopeCommitAction.ADDED).build()));
        }
        if (removedCommits != null) {
            builder.totalRemoved(removedCommits.getTotal());
            removedCommits.getCommits().forEach(commit -> builder.commit(new InternalPullRequestRescopeCommit.Builder().commitId(commit.getId()).action(PullRequestRescopeCommitAction.REMOVED).build()));
        }
        InternalPullRequestRescopeActivity activity = builder.build();
        this.activityDao.create((Object)activity);
        this.eventPublisher.publish((Object)new PullRequestRescopeActivityEvent((Object)this, (PullRequestRescopeActivity)activity));
        if (addedCommits == null || removedCommits == null) {
            this.rescopeProcessor.queue(activity);
        }
    }

    private void maybeUpdate(InternalPullRequest pullRequest) {
        this.commentHelper.maybeUpdateComments(pullRequest);
    }

    private InternalPullRequest rescopeOnReopen(@Nonnull InternalPullRequest pullRequest, @Nonnull Ref resolvedFromRef, @Nonnull Ref resolvedToRef) {
        InternalPullRequestRef originalFromRef = pullRequest.getFromRef();
        InternalPullRequestRef originalToRef = pullRequest.getToRef();
        String latestFromHash = resolvedFromRef.getLatestCommit();
        String latestToHash = resolvedToRef.getLatestCommit();
        if (originalFromRef.getLatestCommit().equals(latestFromHash) && originalToRef.getLatestCommit().equals(latestToHash)) {
            return pullRequest;
        }
        if (this.isMerged(originalFromRef.getRepository(), latestFromHash, originalToRef.getRepository(), latestToHash)) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.reopen.empty", new Object[0]));
        }
        this.updateScope(pullRequest.getGlobalId(), pullRequest.getVersion(), latestFromHash, latestToHash);
        return pullRequest;
    }

    private Ref resolveBranchOrFail(Repository repo, String branch) {
        Ref ref = this.refService.resolveRef(repo, branch);
        if (ref == null) {
            throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.nosuchref", new Object[]{repo.getSlug(), repo.getProject().getKey(), branch}), branch);
        }
        return ref;
    }

    private Page<PullRequest> search(PullRequestSearchCriteria criteria, PageRequest pageRequest, boolean enrich) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        Page<InternalPullRequest> page = this.pullRequestDao.search(criteria, pageRequest.buildRestrictedPageRequest(this.maxPullRequests), this.predicateFactory.createPullRequestPermissionPredicate(Permission.REPO_READ));
        if (enrich && page.getSize() > 0) {
            page = this.pullRequestEnricher.enrich(page);
        }
        return PageUtils.asPageOf(PullRequest.class, (Page)page);
    }

    private PullRequestSearchCriteria toCriteria(PullRequestSearchRequest request) {
        return new PullRequestSearchCriteria.Builder().fromRefIds((Iterable)request.getFromRefIds()).fromRepositoryId(request.getFromRepositoryId()).order(request.getOrder()).participants(this.toParticipantCriteria(request.getParticipants())).state(request.getState()).toRefIds((Iterable)request.getToRefIds()).toRepositoryId(request.getToRepositoryId()).build();
    }

    private Iterable<PullRequestParticipantCriteria> toParticipantCriteria(Collection<PullRequestParticipantRequest> requests) {
        Set usernames = (Set)requests.stream().map(PullRequestParticipantRequest::getUsername).collect(MoreCollectors.toImmutableSet());
        Map usersByName = this.userService.getUsersByName(usernames, true).stream().collect(Collectors.toMap(Principal::getName, Function.identity()));
        if (usersByName.size() != requests.size()) {
            throw new IllegalArgumentException();
        }
        return (Iterable)requests.stream().map(request -> new PullRequestParticipantCriteria.Builder((ApplicationUser)usersByName.get(request.getUsername())).statuses((Iterable)request.getStatuses()).role(request.getRole()).build()).collect(MoreCollectors.toImmutableList());
    }

    private String trimRightToNull(String description) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.stripEnd((String)description, null), null);
    }

    private void validateCanUpdateReviewer(int repositoryId, String username) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null || !currentUser.getSlug().equals(username) && !this.permissionService.hasRepositoryPermission(currentUser, repositoryId, Permission.REPO_WRITE)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.reviewers.permissions.insufficient", new Object[0]));
        }
    }

    private class MergePullRequestOperation
    implements UncheckedOperation<String> {
        private final ApplicationUser author;
        private final Map<String, Object> context;
        private final Date date;
        private final String message;
        private final InternalPullRequest pullRequest;
        private final InternalPullRequestRef fromRef;
        private final InternalPullRequestRef toRef;

        private MergePullRequestOperation(InternalPullRequest pullRequest, ApplicationUser author, Date date, String message, Map<String, Object> context) {
            this.author = author;
            this.context = context;
            this.date = date;
            this.message = message;
            this.pullRequest = pullRequest;
            this.fromRef = pullRequest.getFromRef();
            this.toRef = pullRequest.getToRef();
        }

        public String perform() throws RuntimeException {
            String mergeHash;
            InternalPullRequest locked = this.lockPullRequest(this.pullRequest);
            try {
                Branch branch = (Branch)DefaultPullRequestService.this.scmService.getPullRequestCommandFactory((PullRequest)locked).merge(((PullRequestMergeCommandParameters.Builder)((PullRequestMergeCommandParameters.Builder)new PullRequestMergeCommandParameters.Builder().author(this.author)).context(this.context).message(this.buildMergeMessage())).build()).call();
                String string = mergeHash = branch == null ? null : branch.getLatestCommit();
                if (mergeHash == null) {
                    log.error("{}: Merge of pull request {} succeeded but no merge hash was available", (Object)locked.getScopeRepository(), (Object)locked.getId());
                }
            }
            catch (RuntimeException e) {
                this.unlockPullRequestWithRetries(locked, PullRequestState.OPEN);
                throw e;
            }
            this.unlockPullRequestWithRetries(locked, PullRequestState.MERGED);
            return mergeHash;
        }

        private String buildMergeMessage() {
            StringBuilder format = new StringBuilder("Merge pull request #%1$d in %3$s/%4$s from ");
            if (this.pullRequest.isCrossRepository()) {
                format.append("%6$s/%7$s:%8$s to %5$s");
            } else {
                format.append("%8$s to %5$s");
            }
            if (StringUtils.isNotBlank((CharSequence)this.message)) {
                format.append("\n\n%2$s");
            }
            return String.format(format.toString(), this.pullRequest.getId(), this.message, this.toRef.getRepository().getProject().getKey(), this.toRef.getRepository().getSlug(), this.toRef.getDisplayId(), this.fromRef.getRepository().getProject().getKey(), this.fromRef.getRepository().getSlug(), this.fromRef.getDisplayId());
        }

        private InternalPullRequest lockPullRequest(InternalPullRequest pullRequest) {
            return this.updatePullRequestState(pullRequest, true, pullRequest.getState());
        }

        private InternalPullRequest unlockPullRequestWithRetries(InternalPullRequest pr, PullRequestState state) {
            int attempt = 1;
            while (true) {
                try {
                    return this.updatePullRequestState(pr, false, state);
                }
                catch (RuntimeException e) {
                    if (attempt >= 10) {
                        log.warn("{}: Failed to unlock pull request {} ({} attempts)", new Object[]{this.pullRequest.getScopeRepository(), this.pullRequest.getId(), attempt});
                        throw e;
                    }
                    ++attempt;
                    DefaultPullRequestService.this.pullRequestDao.refresh((Object)pr);
                    continue;
                }
                break;
            }
        }

        private InternalPullRequest updatePullRequestState(InternalPullRequest pr, boolean locked, PullRequestState state) {
            return (InternalPullRequest)DefaultPullRequestService.this.withNewTransaction.execute(status -> (InternalPullRequest)DefaultPullRequestService.this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pr).locked(locked).state(state).updatedDate(this.date).fromRef(new InternalPullRequestRef.Builder(this.fromRef).build()).toRef(new InternalPullRequestRef.Builder(this.toRef).build()).build()));
        }
    }

    private static class IsEmptyCommitCallback
    extends AbstractCommitCallback {
        private boolean empty = true;

        private IsEmptyCommitCallback() {
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public boolean onCommit(@Nonnull Commit commit) {
            this.empty = false;
            return false;
        }
    }

    private static class CountingCommitCallback
    extends AbstractCommitCallback {
        private int count;

        private CountingCommitCallback() {
        }

        public int getCount() {
            return this.count;
        }

        public boolean onCommit(@Nonnull Commit commit) {
            ++this.count;
            return true;
        }
    }
}

