/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.event.permission.ProjectPermissionGrantedEvent;
import com.atlassian.bitbucket.event.project.ProjectAvatarUpdatedEvent;
import com.atlassian.bitbucket.event.project.ProjectCreatedEvent;
import com.atlassian.bitbucket.event.project.ProjectCreationRequestedEvent;
import com.atlassian.bitbucket.event.project.ProjectDeletedEvent;
import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.project.ProjectModificationRequestedEvent;
import com.atlassian.bitbucket.event.project.ProjectModifiedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectCreateRequest;
import com.atlassian.bitbucket.project.ProjectCreationCanceledException;
import com.atlassian.bitbucket.project.ProjectDeletionCanceledException;
import com.atlassian.bitbucket.project.ProjectModificationCanceledException;
import com.atlassian.bitbucket.project.ProjectSearchRequest;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.project.ProjectSupplier;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.project.ProjectUpdateRequest;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.TrustedCreate;
import com.atlassian.bitbucket.validation.groups.TrustedUpdate;
import com.atlassian.bitbucket.validation.groups.Update;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.avatar.DataUriAvatarMetaSupplier;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.project.DefaultProjectSupplier;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={ProjectService.class, ProjectSupplier.class})
@Service(value="projectService")
public class DefaultProjectService
extends DefaultProjectSupplier
implements InternalProjectService {
    private static final Supplier<AvatarSupplier> NO_AVATAR = Suppliers.ofInstance(null);
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectService.class);
    private final AuthenticationContext authenticationContext;
    private final InternalAvatarService avatarService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final ApplicationMode mode;
    private final ProjectPermissionDao permissionDao;
    private final PermissionService permissionService;
    private final PermissionPredicateFactory predicateFactory;
    private final SecurityService securityService;
    private final Validator validator;
    private int maxProjects;

    @Autowired
    public DefaultProjectService(AuthenticationContext authenticationContext, InternalAvatarService avatarService, EventPublisher eventPublisher, I18nService i18nService, @Value(value="#{applicationPropertiesService.mode}") ApplicationMode mode, PermissionService permissionService, ProjectPermissionDao permissionDao, PermissionPredicateFactory predicateFactory, ProjectDao projectDao, SecurityService securityService, Validator validator) {
        super(projectDao);
        this.mode = mode;
        this.authenticationContext = authenticationContext;
        this.avatarService = avatarService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionDao = permissionDao;
        this.permissionService = permissionService;
        this.predicateFactory = predicateFactory;
        this.securityService = securityService;
        this.validator = validator;
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasGlobalPermission('PROJECT_CREATE')")
    public InternalProject create(@Nonnull ProjectCreateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Supplier<AvatarSupplier> metaSupplier = this.getAvatarSupplier(request);
        InternalNormalProject project = ((InternalNormalProject.Builder)new InternalNormalProject.Builder().description(request.getDescription()).key(request.getKey()).name(request.getName()).namespace(request.getNamespace())).publiclyAccessible(request.isPublic()).build();
        ValidationUtils.validate((Validator)this.validator, (Object)project, (Class[])new Class[]{this.isMirrorMode() ? TrustedCreate.class : Create.class});
        this.fireProjectCreationRequested((Project)project);
        InternalProject created = (InternalProject)this.projectDao.create((Object)project);
        log.info("Created new project: ({}) {}", (Object)request.getKey(), (Object)request.getName());
        this.securityService.withPermission(Permission.PROJECT_ADMIN, "Creating project with avatar").call(() -> {
            AvatarSupplier supplier = (AvatarSupplier)metaSupplier.get();
            if (supplier != null) {
                this.avatarService.saveForProject((Project)created, supplier);
            }
            return null;
        });
        this.grantProjectAdminToCreator((InternalProject)project, this.authenticationContext.getCurrentUser());
        this.fireProjectCreated((Project)project);
        return created;
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    @Transactional
    public boolean delete(Project project) {
        InternalProject internalProject = (InternalProject)this.projectDao.getById((Object)project.getId());
        if (internalProject == null) {
            return false;
        }
        if (project.getType() == ProjectType.PERSONAL) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.project.personal.notdeletable", new Object[0]));
        }
        if (this.projectDao.hasRepositories(internalProject.getId())) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.project.notempty", new Object[]{internalProject.getKey()});
            throw new IntegrityException(message);
        }
        this.fireProjectDeletionRequested(project);
        this.projectDao.delete((Object)internalProject);
        this.eventPublisher.publish((Object)new ProjectDeletedEvent((Object)this, project));
        return true;
    }

    @Nonnull
    @Secured(value="Secured using a project accessible predicate")
    public Page<Project> findAll(@Nonnull PageRequest pageRequest) {
        PageRequest restrictedPageRequest = pageRequest.buildRestrictedPageRequest(this.maxProjects);
        return PageUtils.asPageOf(Project.class, (Page)this.projectDao.findAll(restrictedPageRequest, this.predicateFactory.createProjectAccessiblePredicate()));
    }

    @Nonnull
    @Secured(value="Secured using a predicate")
    public List<String> findAllKeys() {
        Predicate predicate = this.predicateFactory.createProjectAccessiblePredicate();
        Iterable keys = this.projectDao.findAllKeys(predicate);
        return ImmutableList.copyOf((Iterable)keys);
    }

    @Nonnull
    @PostAuthorize(value="isProjectAccessible(#projectId)")
    public CacheableAvatarSupplier getAvatar(int projectId, int size) {
        InternalProject project = this.getProjectOrFail(projectId);
        return this.avatarService.getForProject((Project)project, size);
    }

    @Unsecured(value="Internal service method, this method is also exposed via JMX")
    public long getCount() {
        return this.projectDao.countAll();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    @Transactional
    public InternalPersonalProject getPersonalProject() {
        return this.getPersonalProject(true);
    }

    @Nonnull
    @PostAuthorize(value="hasGlobalPermission('LICENSED_USER') or isProjectAccessible(returnObject)")
    @Transactional
    public InternalPersonalProject getPersonalProject(@Nonnull ApplicationUser user) {
        return this.getOrCreatePersonalProject((ApplicationUser)Preconditions.checkNotNull((Object)user, (Object)"user"), true);
    }

    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    @Transactional
    public InternalPersonalProject getPersonalProject(boolean create) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.project.personal.anonymous", new Object[0]));
        }
        return this.getOrCreatePersonalProject(currentUser, create);
    }

    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public boolean isPersonalProject(@Nonnull String projectKey) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        return currentUser != null && currentUser.getName().equalsIgnoreCase(InternalPersonalProject.getPersonalProjectOwner((String)projectKey));
    }

    @EventListener
    public void onUserCreated(UserCreatedEvent event) {
        InternalPersonalProject project = this.projectDao.getByUsername(event.getUser().getName());
        if (project != null && !this.permissionService.hasProjectPermission((ApplicationUser)project.getOwner(), (Project)project, Permission.PROJECT_ADMIN)) {
            this.grantProjectAdminToCreator((InternalProject)project, (ApplicationUser)project.getOwner());
        }
    }

    @Nonnull
    @Secured(value="Secured using a predicate for (at least) project accessible checks")
    public Page<Project> search(@Nonnull ProjectSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)searchRequest, (Object)"searchRequest");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxProjects);
        Predicate permissionPredicate = searchRequest.hasPermission() ? this.predicateFactory.createProjectPermissionPredicate(searchRequest.getPermission()) : this.predicateFactory.createProjectAccessiblePredicate();
        return PageUtils.asPageOf(Project.class, (Page)this.projectDao.search(searchRequest, pageRequest, permissionPredicate));
    }

    @Value(value="${page.max.projects}")
    public void setMaxProjects(int maxProjects) {
        this.maxProjects = maxProjects;
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasProjectPermission(#request.id, 'PROJECT_ADMIN')")
    public InternalProject update(@Nonnull ProjectUpdateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalNormalProject project = (InternalNormalProject)HibernateUtils.tryCast((Object)this.getProjectOrFail(request.getId()), InternalNormalProject.class);
        if (project == null) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.project.personal.detailsunmodifiable", new Object[0]));
        }
        InternalNormalProject current = project.copy().build();
        InternalNormalProject updated = current.copy().description(request.getDescription()).key(request.getKey()).name(request.getName()).publiclyAccessible(request.isPublic()).build();
        ValidationUtils.validate((Validator)this.validator, (Object)updated, (Class[])new Class[]{this.isMirrorMode() ? TrustedUpdate.class : Update.class});
        this.fireProjectModificationRequested((Project)current, (Project)updated);
        updated = (InternalProject)this.projectDao.update((Object)updated);
        this.eventPublisher.publish((Object)new ProjectModifiedEvent((Object)this, (Project)current, (Project)updated));
        return updated;
    }

    @PreAuthorize(value="hasProjectPermission(#projectId, 'PROJECT_ADMIN')")
    public void updateAvatar(int projectId, @Nonnull AvatarSupplier supplier) {
        Preconditions.checkNotNull((Object)supplier, (Object)"supplier");
        this.doUpdateAvatar(projectId, (Supplier<AvatarSupplier>)Suppliers.ofInstance((Object)supplier));
    }

    @PreAuthorize(value="hasProjectPermission(#projectId, 'PROJECT_ADMIN')")
    public void updateAvatar(int projectId, @Nonnull String uri) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)uri, (Object)"uri")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank data URI is required");
        this.doUpdateAvatar(projectId, new DataUriAvatarMetaSupplier(this.avatarService, uri));
    }

    private void doUpdateAvatar(int projectId, Supplier<AvatarSupplier> metaSupplier) {
        InternalProject project = this.getProjectOrFail(projectId);
        if (project.getType() == ProjectType.PERSONAL) {
            if (this.avatarService.isEnabled()) {
                throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.project.personal.avatarunmodifiable.usegravatar", new Object[]{Product.NAME}));
            }
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.project.personal.avatarunmodifiable", new Object[0]));
        }
        this.avatarService.saveForProject((Project)project, (AvatarSupplier)metaSupplier.get());
        this.eventPublisher.publish((Object)new ProjectAvatarUpdatedEvent((Object)this, (Project)project));
    }

    private void fireProjectCreated(Project project) {
        this.eventPublisher.publish((Object)new ProjectCreatedEvent((Object)this, project));
    }

    private void fireProjectCreationRequested(Project project) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new ProjectCreationRequestedEvent((Object)this, project, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.project.creationcanceled", new Object[0]);
            throw new ProjectCreationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireProjectDeletionRequested(Project project) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new ProjectDeletionRequestedEvent((Object)this, project, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.project.deletioncanceled", new Object[0]);
            throw new ProjectDeletionCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireProjectModificationRequested(Project current, Project updated) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new ProjectModificationRequestedEvent((Object)this, current, updated, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.project.updatedcanceled", new Object[0]);
            throw new ProjectModificationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private Supplier<AvatarSupplier> getAvatarSupplier(ProjectCreateRequest request) {
        if (request.getAvatar() != null) {
            return Suppliers.ofInstance((Object)request.getAvatar());
        }
        if (!StringUtils.isBlank((CharSequence)request.getAvatarUri())) {
            return new DataUriAvatarMetaSupplier(this.avatarService, request.getAvatarUri());
        }
        return NO_AVATAR;
    }

    private InternalPersonalProject getOrCreatePersonalProject(ApplicationUser user, boolean create) {
        InternalPersonalProject project = this.projectDao.getByOwner(user.getId());
        if (project == null) {
            if (create) {
                InternalNormalUser stashUser = (InternalNormalUser)InternalConverter.convertToInternalUser((ApplicationUser)user).accept((InternalStashUserVisitor)InternalNormalUser.TO_NORMAL_USER);
                project = new InternalPersonalProject.Builder().owner(stashUser).build();
                project = this.projectDao.createPersonal(project);
                log.debug("Created personal project {}", (Object)project.getKey());
                this.grantProjectAdminToCreator((InternalProject)project, user);
                this.fireProjectCreated((Project)project);
            } else {
                log.trace("User {} does not yet have a personal project, and one has not been created", (Object)user.getName());
            }
        } else {
            log.trace("Personal project {} already exists; returning the existing project", (Object)project.getKey());
        }
        return project;
    }

    @Nonnull
    private InternalProject getProjectOrFail(int projectId) {
        InternalProject project = this.getById(projectId);
        if (project == null) {
            throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.service.project.nosuchid", new Object[]{projectId}));
        }
        return project;
    }

    private void grantProjectAdminToCreator(InternalProject project, ApplicationUser creator) {
        InternalApplicationUser user = InternalConverter.convertToInternalUser((ApplicationUser)creator);
        InternalProjectPermission permission = ((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(Permission.PROJECT_ADMIN)).project(project).user(user)).build();
        this.permissionDao.create((Object)permission);
        this.eventPublisher.publish((Object)new ProjectPermissionGrantedEvent((Object)this, Permission.PROJECT_ADMIN, (Project)project, null, creator));
        log.debug("Granted {} to {} for project {}", new Object[]{Permission.PROJECT_ADMIN, creator.getName(), project.getKey()});
    }

    private boolean isMirrorMode() {
        return this.mode == ApplicationMode.MIRROR;
    }
}

