/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pullrequest;

import com.atlassian.bitbucket.comment.DiffCommentAnchor;
import com.atlassian.bitbucket.event.pull.PullRequestActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentAddedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentRepliedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantReviewedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantUnapprovedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReopenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewersUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRolesUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.notification.Notification;
import com.atlassian.bitbucket.notification.pull.CommentAddedPullRequestNotification;
import com.atlassian.bitbucket.notification.pull.CommentRepliedPullRequestNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestActivityNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestApprovedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestClosedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestFromRefRescopedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestMergedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestOpenedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestReopenedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestReviewedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestReviewerAddedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestReviewersUpdatedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestUnapprovedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestUpdatedNotification;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.notification.NotificationManager;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullRequestNotificationProducer {
    private final NotificationManager notificationManager;

    @Autowired
    public PullRequestNotificationProducer(@Nonnull NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @EventListener
    public void onActivityEvent(PullRequestActivityEvent event) {
        PullRequestActivityNotification notification = new PullRequestActivityNotification(event.getActivity(), event.getDate(), event.getUser());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestCommentAdded(PullRequestCommentAddedEvent event) {
        CommentAddedPullRequestNotification notification = new CommentAddedPullRequestNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getComment(), (DiffCommentAnchor)event.getAnchor());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestCommentReplied(PullRequestCommentRepliedEvent event) {
        CommentRepliedPullRequestNotification notification = new CommentRepliedPullRequestNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getComment(), event.getParent());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestUpdatedEvent(PullRequestUpdatedEvent event) {
        this.notificationManager.dispatch((Notification)new PullRequestUpdatedNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getPreviousTitle(), event.getPreviousDescription(), event.getPreviousToBranch()));
    }

    @EventListener
    public void onPullRequestOpened(PullRequestOpenedEvent event) {
        this.dispatchReviewerAddedNotification((PullRequestEvent)event, (List)event.getPullRequest().getReviewers().stream().map(PullRequestParticipant::getUser).collect(MoreCollectors.toImmutableList()));
        this.notificationManager.dispatch((Notification)new PullRequestOpenedNotification(event.getPullRequest(), event.getDate(), event.getUser()));
    }

    @EventListener
    public void onPullRequestReviewersUpdated(PullRequestReviewersUpdatedEvent event) {
        this.dispatchReviewerAddedNotification((PullRequestEvent)event, Lists.newArrayList((Iterable)event.getAddedReviewers()));
        this.dispatchReviewerUpdatedNotification((PullRequestRolesUpdatedEvent)event);
    }

    @EventListener
    public void onPullRequestMerged(PullRequestMergedEvent event) {
        PullRequestMergedNotification notification = new PullRequestMergedNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getCommit());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestClosed(PullRequestDeclinedEvent event) {
        PullRequestClosedNotification notification = new PullRequestClosedNotification(event.getPullRequest(), event.getDate(), event.getUser());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestReopened(PullRequestReopenedEvent event) {
        PullRequestReopenedNotification notification = new PullRequestReopenedNotification(event.getPullRequest(), event.getDate(), event.getUser());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestRescoped(PullRequestRescopedEvent event) {
        if (event.isFromHashUpdated()) {
            PullRequestFromRefRescopedNotification notification = new PullRequestFromRefRescopedNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getPreviousFromHash(), event.getPreviousToHash());
            this.notificationManager.dispatch((Notification)notification);
        }
    }

    @EventListener
    public void onPullRequestReviewed(PullRequestParticipantReviewedEvent event) {
        PullRequestApprovedNotification notification = event.getParticipant().isApproved() ? new PullRequestApprovedNotification(event.getPullRequest(), event.getDate(), event.getUser()) : new PullRequestReviewedNotification(event.getPullRequest(), event.getDate(), event.getUser());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestUnapproved(PullRequestParticipantUnapprovedEvent event) {
        if (event.getPreviousStatus() != PullRequestParticipantStatus.NEEDS_WORK) {
            PullRequestUnapprovedNotification notification = new PullRequestUnapprovedNotification(event.getPullRequest(), event.getDate(), event.getUser());
            this.notificationManager.dispatch((Notification)notification);
        }
    }

    private void dispatchReviewerAddedNotification(PullRequestEvent event, List<ApplicationUser> reviewers) {
        if (!reviewers.isEmpty()) {
            PullRequestReviewerAddedNotification notification = new PullRequestReviewerAddedNotification(event.getPullRequest(), event.getDate(), event.getUser(), reviewers);
            this.notificationManager.dispatch((Notification)notification);
        }
    }

    private void dispatchReviewerUpdatedNotification(PullRequestRolesUpdatedEvent event) {
        this.notificationManager.dispatch((Notification)new PullRequestReviewersUpdatedNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getAddedReviewers(), event.getRemovedReviewers()));
    }
}

