/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.bitbucket.mail.HtmlCssInliner;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.botocss.Botocss;
import com.atlassian.botocss.BotocssStyles;
import com.atlassian.botocss.DocumentFunctions;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.mail.BotocssStylesResolver;
import com.google.common.base.Function;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=HtmlCssInliner.class)
@Component(value="htmlCssInliner")
@Profiled
public class HtmlCssInlinerImpl
implements HtmlCssInliner {
    private static final String CSS_RESOURCE_BASE_URL_TOKEN = "$$$$base.resource.url$$$$";
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final BotocssStylesResolver botocssStylesResolver;
    private final NavBuilder navBuilder;

    @Autowired
    public HtmlCssInlinerImpl(WebResourceUrlProvider webResourceUrlProvider, BotocssStylesResolver botocssStylesResolver, NavBuilder navBuilder) {
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.botocssStylesResolver = botocssStylesResolver;
        this.navBuilder = navBuilder;
    }

    public String inlineCss(String html, String cssModuleKey) {
        BotocssStyles botoCSStylesForModuleKey = this.botocssStylesResolver.getBotocssStylesForModuleKey(cssModuleKey);
        String injectedStyles = Botocss.inject((String)html, (BotocssStyles)botoCSStylesForModuleKey, (Function)DocumentFunctions.ZERO_INDENT);
        String staticPluginResourceUrl = this.webResourceUrlProvider.getStaticPluginResourceUrl(cssModuleKey, "", UrlMode.ABSOLUTE);
        String requestBaseUrl = this.navBuilder.buildAbsolute();
        String configuredBaseUrl = this.navBuilder.buildConfigured();
        injectedStyles = StringUtils.replace((String)injectedStyles, (String)CSS_RESOURCE_BASE_URL_TOKEN, (String)(configuredBaseUrl + staticPluginResourceUrl.substring(requestBaseUrl.length())));
        return injectedStyles;
    }
}

